/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.radius.server.filter;

import org.apache.log4j.Logger;
import org.gluu.oxauth.client.supergluu.SuperGluuAuthClient;
import org.gluu.oxauth.client.supergluu.SuperGluuAuthClientConfig;
import org.gluu.oxauth.client.supergluu.SuperGluuAuthScheme;
import org.gluu.oxauth.client.supergluu.SuperGluuAuthStatus;
import org.gluu.oxauth.client.supergluu.impl.ICryptoProviderFactory;
import org.gluu.oxauth.client.supergluu.impl.IHttpClientFactory;
import org.gluu.oxauth.client.supergluu.impl.http.PoolingConnectionHttpClientFactory;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.radius.exception.GluuRadiusException;
import org.gluu.radius.server.AccessRequestContext;
import org.gluu.radius.server.AccessRequestFilter;
import org.gluu.radius.server.filter.SuperGluuAccessRequestFilterConfig;
import org.gluu.radius.service.CryptoService;
import org.json.JSONObject;

public class SuperGluuAccessRequestFilter
implements AccessRequestFilter {
    private static final Logger log = Logger.getLogger(SuperGluuAccessRequestFilter.class);
    private static final long statusCheckInterval = 50L;
    private IHttpClientFactory httpClientFactory = new PoolingConnectionHttpClientFactory();
    private SuperGluuAccessRequestFilterConfig filterConfig;

    public SuperGluuAccessRequestFilter(SuperGluuAccessRequestFilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processAccessRequest(AccessRequestContext context) {
        boolean ret = false;
        CryptoService cryptoService = this.filterConfig.getCryptoService();
        try {
            cryptoService.beginReadOpts();
            if (this.filterConfig.isOneStepAuth()) {
                ret = this.performOneStepAuth(context);
            } else if (this.filterConfig.isTwoStepAuth()) {
                ret = this.performTwoStepAuth(context);
            } else {
                log.debug((Object)"Authentication scheme is neither one-step nor two-step");
            }
        }
        finally {
            cryptoService.endReadOpts();
        }
        return ret;
    }

    private final boolean performOneStepAuth(AccessRequestContext context) {
        try {
            SuperGluuAuthClient client = this.createAuthClient();
            client.setAuthScheme(SuperGluuAuthScheme.ONE_STEP);
            String ipaddress = context.getClientIpAddress();
            String username = context.getUsername();
            String password = context.getPassword();
            log.debug((Object)String.format("Performing one-step authentication for user {%s}", username));
            Boolean initiateresult = client.initiateAuthentication(username, password, ipaddress);
            if (initiateresult == null || initiateresult != null && !initiateresult.booleanValue()) {
                log.debug((Object)String.format("Authentication failed for user {%s}", username));
                return false;
            }
            log.debug((Object)String.format("Authentication success for user {%s}", username));
            return true;
        }
        catch (GluuRadiusException e) {
            String username = context.getUsername();
            log.debug((Object)String.format("Authentication failed for user {%s}", username), (Throwable)e);
        }
        catch (Exception e) {
            String username = context.getUsername();
            log.debug((Object)String.format("Authentication failed for user {%s}", username), (Throwable)e);
        }
        return false;
    }

    private final boolean performTwoStepAuth(AccessRequestContext context) {
        try {
            SuperGluuAuthClient client = this.createAuthClient();
            client.setAuthScheme(SuperGluuAuthScheme.TWO_STEP);
            String ipaddress = context.getClientIpAddress();
            String username = context.getUsername();
            String password = context.getPassword();
            log.debug((Object)String.format("Performing two-step authentication for user {%s}", username));
            long authstart = System.currentTimeMillis();
            Boolean initiateresult = client.initiateAuthentication(username, password, ipaddress);
            if (initiateresult == null || initiateresult != null && !initiateresult.booleanValue()) {
                log.debug((Object)String.format("Authentication failed for user {%s}.", username));
                return false;
            }
            log.debug((Object)String.format("User {%s} step one auth success. Checking step-two auth result", username));
            SuperGluuAuthStatus authstatus = SuperGluuAuthStatus.UNAUTHENTICATED;
            while (System.currentTimeMillis() - authstart < this.filterConfig.getAuthenticationTimeout() && (authstatus = client.checkAuthenticationStatus()) != SuperGluuAuthStatus.AUTHENTICATED) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (authstatus == SuperGluuAuthStatus.UNAUTHENTICATED) {
                log.debug((Object)String.format("Authentication timeout for user {%s}", username));
                return false;
            }
            log.debug((Object)String.format("Performing additional two-step verification for user {%s}", username));
            Boolean verifyauth = client.verifyAuthentication(username, password);
            if (verifyauth == null || verifyauth != null && !verifyauth.booleanValue()) {
                log.debug((Object)String.format("Two-step additional verification failed for user {%s}", username));
                return false;
            }
            log.debug((Object)String.format("Authentication success for user {%s}", username));
            return true;
        }
        catch (GluuRadiusException e) {
            String username = context.getUsername();
            log.debug((Object)String.format("Authentication failed for user {%s}", username));
        }
        catch (Exception e) {
            String username = context.getUsername();
            log.debug((Object)String.format("Authentication failed for user {%s}", username));
        }
        return false;
    }

    private final SuperGluuAuthClient createAuthClient() {
        SuperGluuAuthClientConfig config = this.createAuthClientConfig();
        ICryptoProviderFactory factory = this.filterConfig.getCryptoProviderFactory();
        JSONObject keyset = this.filterConfig.getServerKeyset();
        return new SuperGluuAuthClient(config, this.httpClientFactory, factory, keyset);
    }

    private final SuperGluuAuthClientConfig createAuthClientConfig() {
        String keyId = this.filterConfig.getJwtAuthKeyId();
        SignatureAlgorithm algorithm = this.filterConfig.getJwtAuthSignAlgo();
        String audience = this.filterConfig.getTokenEndpointUrl();
        SuperGluuAuthClientConfig config = new SuperGluuAuthClientConfig(keyId, algorithm, audience);
        config.setClientId(this.filterConfig.getOpenidUsername());
        config.setTokenEndpointUrl(this.filterConfig.getTokenEndpointUrl());
        config.setSessionStatusUrl(this.filterConfig.getSessionStatusUrl());
        config.setAcrValue(this.filterConfig.getAcrValue());
        for (String scope : this.filterConfig.getScopes()) {
            config.addScope(scope);
        }
        return config;
    }
}

