/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.radius.server;

import java.util.ArrayList;
import java.util.List;
import org.gluu.radius.model.ServerConfiguration;
import org.gluu.radius.server.AccessRequestFilter;
import org.gluu.radius.server.AccountingRequestFilter;
import org.gluu.radius.server.RadiusClientMatcher;

public class RunConfiguration {
    private String listenInterface = "0.0.0.0";
    private Integer authListenPort = ServerConfiguration.DEFAULT_RADIUS_AUTH_PORT;
    private Integer acctListenPort = ServerConfiguration.DEFAULT_RADIUS_ACCT_PORT;
    private List<AccessRequestFilter> accessRequestFilters = new ArrayList<AccessRequestFilter>();
    private List<AccountingRequestFilter> accountingRequestFilters = new ArrayList<AccountingRequestFilter>();
    private List<RadiusClientMatcher> clientMatchers = new ArrayList<RadiusClientMatcher>();

    public String getListenInterface() {
        return this.listenInterface;
    }

    public RunConfiguration setListenInterface(String listenInterface) {
        this.listenInterface = listenInterface;
        return this;
    }

    public Integer getAuthListenPort() {
        return this.authListenPort;
    }

    public RunConfiguration setAuthListenPort(Integer authListenPort) {
        this.authListenPort = authListenPort;
        return this;
    }

    public Integer getAcctListenPort() {
        return this.acctListenPort;
    }

    public RunConfiguration setAcctListenPort(Integer acctListenPort) {
        this.acctListenPort = acctListenPort;
        return this;
    }

    public List<AccessRequestFilter> getAccessRequestFilters() {
        return this.accessRequestFilters;
    }

    public RunConfiguration addAccessRequestFilter(AccessRequestFilter accessRequestFilter) {
        this.accessRequestFilters.add(accessRequestFilter);
        return this;
    }

    public List<AccountingRequestFilter> getAccountingRequestFilters() {
        return this.accountingRequestFilters;
    }

    public RunConfiguration addAccountingRequestFilter(AccountingRequestFilter accountingRequestFilter) {
        this.accountingRequestFilters.add(accountingRequestFilter);
        return this;
    }

    public List<RadiusClientMatcher> getClientMatchers() {
        return this.clientMatchers;
    }

    public RunConfiguration addClientMatcher(RadiusClientMatcher clientMatcher) {
        this.clientMatchers.add(clientMatcher);
        return this;
    }

    public static final RunConfiguration fromServerConfiguration(ServerConfiguration serverConfig) {
        RunConfiguration runConfig = new RunConfiguration();
        runConfig.setListenInterface(serverConfig.getListenInterface());
        runConfig.setAuthListenPort(serverConfig.getAuthPort());
        runConfig.setAcctListenPort(serverConfig.getAcctPort());
        return runConfig;
    }
}

