/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.radius.server;

import java.util.ArrayList;
import java.util.List;
import org.gluu.radius.server.AccessRequestContext;
import org.gluu.radius.server.AccountingRequestContext;
import org.gluu.radius.server.RadiusEventListener;
import org.gluu.radius.server.SharedSecretRequestContext;

public class RadiusEventListenerManager {
    private List<RadiusEventListener> listeners = new ArrayList<RadiusEventListener>();

    public RadiusEventListenerManager addListener(RadiusEventListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
        return this;
    }

    public RadiusEventListenerManager removeListener(RadiusEventListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
        return this;
    }

    public RadiusEventListenerManager accessRequestNotification(AccessRequestContext context) {
        for (RadiusEventListener listener : this.listeners) {
            listener.onAccessRequest(context);
        }
        return this;
    }

    public RadiusEventListenerManager accountingRequestNotification(AccountingRequestContext context) {
        for (RadiusEventListener listener : this.listeners) {
            listener.onAccountingRequest(context);
        }
        return this;
    }

    public RadiusEventListenerManager sharedSecretRequestNotification(SharedSecretRequestContext context) {
        for (RadiusEventListener listener : this.listeners) {
            listener.onSharedSecretRequest(context);
        }
        return this;
    }
}

