/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.radius.server;

import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.gluu.radius.model.RadiusClient;
import org.gluu.radius.server.AccessRequestContext;
import org.gluu.radius.server.AccessRequestFilter;
import org.gluu.radius.server.AccountingRequestContext;
import org.gluu.radius.server.AccountingRequestFilter;
import org.gluu.radius.server.RadiusClientMatcher;
import org.gluu.radius.server.RadiusEventListener;
import org.gluu.radius.server.RadiusServerAdapter;
import org.gluu.radius.server.RunConfiguration;
import org.gluu.radius.server.SharedSecretRequestContext;
import org.gluu.radius.service.RadiusClientService;
import org.gluu.radius.util.EncDecUtil;

public final class GluuRadiusServer
implements RadiusEventListener {
    private static final Logger log = Logger.getLogger(GluuRadiusServer.class);
    private RunConfiguration runConfig;
    private RadiusServerAdapter radiusServerAdapter;
    private RadiusClientService radiusClientService;
    private String salt;

    public GluuRadiusServer(RunConfiguration runConfig, RadiusServerAdapter radiusServerAdapter, RadiusClientService radiusClientService, String salt) {
        this.runConfig = runConfig != null ? runConfig : new RunConfiguration();
        this.radiusServerAdapter = radiusServerAdapter;
        this.radiusClientService = radiusClientService;
        this.salt = salt;
    }

    public final GluuRadiusServer run() {
        this.radiusServerAdapter.configureServer(this.runConfig.getListenInterface(), this.runConfig.getAuthListenPort(), this.runConfig.getAcctListenPort());
        this.radiusServerAdapter.registerRadiusEventListener(this);
        this.radiusServerAdapter.runServer();
        return this;
    }

    public final GluuRadiusServer stop() {
        this.radiusServerAdapter.stopServer();
        return this;
    }

    @Override
    public void onAccessRequest(AccessRequestContext context) {
        boolean granted = false;
        for (AccessRequestFilter filter : this.runConfig.getAccessRequestFilters()) {
            if (!filter.processAccessRequest(context)) continue;
            granted = true;
            break;
        }
        context.setGranted(granted);
    }

    @Override
    public void onAccountingRequest(AccountingRequestContext context) {
        for (AccountingRequestFilter filter : this.runConfig.getAccountingRequestFilters()) {
            filter.processAccountingRequest(context);
        }
    }

    @Override
    public void onSharedSecretRequest(SharedSecretRequestContext context) {
        try {
            List<RadiusClient> clients = this.radiusClientService.getRadiusClients();
            clients.sort(new RadiusClientComparator());
            block2: for (RadiusClient client : clients) {
                log.info((Object)String.format("Client ip: %s", context.getClientIpAddress()));
                for (RadiusClientMatcher matcher : this.runConfig.getClientMatchers()) {
                    if (!matcher.match(context.getClientIpAddress(), client)) continue;
                    String secret = EncDecUtil.decode(client.getSecret(), this.salt);
                    context.setSharedSecret(secret);
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            log.info((Object)"Shared secret request failed", (Throwable)e);
        }
    }

    public static class RadiusClientComparator
    implements Comparator<RadiusClient> {
        @Override
        public int compare(RadiusClient first, RadiusClient second) {
            if (first == null && second == null) {
                return 0;
            }
            if (first == null && second != null) {
                return -1;
            }
            if (first != null && second == null) {
                return 1;
            }
            if (first.getPriority() == null && second.getPriority() == null) {
                return 0;
            }
            if (first.getPriority() == null && second.getPriority() != null) {
                return -1;
            }
            if (first.getPriority() != null && second.getPriority() != null) {
                return 1;
            }
            if (first.getPriority() < second.getPriority()) {
                return -1;
            }
            if (first.getPriority() > second.getPriority()) {
                return 1;
            }
            return 0;
        }
    }
}

