/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.radius;

import java.util.List;
import org.gluu.radius.KnownService;
import org.gluu.radius.ServiceLocator;
import org.gluu.radius.exception.ServerFactoryException;
import org.gluu.radius.exception.ServiceException;
import org.gluu.radius.model.AuthScope;
import org.gluu.radius.model.ServerConfiguration;
import org.gluu.radius.server.GluuRadiusServer;
import org.gluu.radius.server.RadiusServerAdapter;
import org.gluu.radius.server.RunConfiguration;
import org.gluu.radius.server.filter.SuperGluuAccessRequestFilter;
import org.gluu.radius.server.filter.SuperGluuAccessRequestFilterConfig;
import org.gluu.radius.server.matcher.CidrSubnetMatcher;
import org.gluu.radius.server.matcher.IpAddressMatcher;
import org.gluu.radius.server.tinyradius.TinyRadiusServerAdapter;
import org.gluu.radius.service.BootstrapConfigService;
import org.gluu.radius.service.CryptoService;
import org.gluu.radius.service.OpenIdConfigurationService;
import org.gluu.radius.service.RadiusClientService;
import org.gluu.radius.service.ServerConfigService;

public class ServerFactory {
    private ServerFactory() {
    }

    public static final GluuRadiusServer createServer() {
        RadiusClientService rcService = (RadiusClientService)ServiceLocator.getService(KnownService.RadiusClient);
        BootstrapConfigService bcService = (BootstrapConfigService)ServiceLocator.getService(KnownService.BootstrapConfig);
        return new GluuRadiusServer(ServerFactory.createRunConfiguration(), ServerFactory.createServerAdapter(), rcService, bcService.getEncodeSalt());
    }

    private static final RadiusServerAdapter createServerAdapter() {
        return new TinyRadiusServerAdapter();
    }

    private static final RunConfiguration createRunConfiguration() {
        ServerConfiguration serverConfig = ServerFactory.getServerConfiguration();
        RunConfiguration runConfig = RunConfiguration.fromServerConfiguration(serverConfig);
        ServerFactory.addClientMatchers(runConfig);
        ServerFactory.addAccessRequestFilters(runConfig);
        ServerFactory.addAccountingRequestFilters(runConfig);
        return runConfig;
    }

    private static final void addClientMatchers(RunConfiguration runConfig) {
        runConfig.addClientMatcher(new IpAddressMatcher());
        runConfig.addClientMatcher(new CidrSubnetMatcher());
    }

    public static final void addAccessRequestFilters(RunConfiguration runConfig) {
        runConfig.addAccessRequestFilter(new SuperGluuAccessRequestFilter(ServerFactory.getSuperGluuAccessRequestFilterConfig()));
    }

    public static final void addAccountingRequestFilters(RunConfiguration runConfig) {
    }

    private static final ServerConfiguration getServerConfiguration() {
        try {
            ServerConfigService scService = (ServerConfigService)ServiceLocator.getService(KnownService.ServerConfig);
            return scService.getServerConfiguration();
        }
        catch (ServiceException e) {
            throw new ServerFactoryException("Error getting server configuration", e);
        }
    }

    private static final List<AuthScope> getAuthScopes(ServerConfiguration serverConfig) {
        try {
            ServerConfigService scService = (ServerConfigService)ServiceLocator.getService(KnownService.ServerConfig);
            return scService.getScopes(serverConfig);
        }
        catch (ServiceException e) {
            throw new ServerFactoryException("Error getting server configuration", e);
        }
    }

    private static final SuperGluuAccessRequestFilterConfig getSuperGluuAccessRequestFilterConfig() {
        ServerConfiguration serverConfig = ServerFactory.getServerConfiguration();
        List<AuthScope> scopes = ServerFactory.getAuthScopes(serverConfig);
        BootstrapConfigService bcService = (BootstrapConfigService)ServiceLocator.getService(KnownService.BootstrapConfig);
        OpenIdConfigurationService openIdConfigService = (OpenIdConfigurationService)ServiceLocator.getService(KnownService.OpenIdConfig);
        CryptoService cryptoService = (CryptoService)ServiceLocator.getService(KnownService.Crypto);
        return new SuperGluuAccessRequestFilterConfig(bcService, serverConfig, scopes, openIdConfigService, cryptoService);
    }
}

