/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.orm.hybrid.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gluu.orm.hybrid.impl.HybridEntryManager;
import org.gluu.orm.hybrid.impl.HybridPersistenceOperationService;
import org.gluu.orm.util.PropertiesHelper;
import org.gluu.orm.util.StringHelper;
import org.gluu.orm.util.properties.FileConfiguration;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.PersistenceEntryManagerFactory;
import org.gluu.persist.exception.operation.ConfigurationException;
import org.gluu.persist.operation.PersistenceOperationService;
import org.gluu.persist.service.BaseFactoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class HybridEntryManagerFactory
implements PersistenceEntryManagerFactory {
    public static final String BASE_DIR = System.getProperty("gluu.base") != null ? System.getProperty("gluu.base") : (System.getProperty("catalina.base") != null && System.getProperty("catalina.base.ignore") == null ? System.getProperty("catalina.base") : (System.getProperty("catalina.home") != null ? System.getProperty("catalina.home") : (System.getProperty("jboss.home.dir") != null ? System.getProperty("jboss.home.dir") : null)));
    public static final String DIR = BASE_DIR + File.separator + "conf" + File.separator;
    public static final String PERSISTENCE_TYPE = PersistenceEntryManager.PERSITENCE_TYPES.hybrid.name();
    public static final String PROPERTIES_FILE = "gluu-hybrid%s.properties";
    private static final Logger LOG = LoggerFactory.getLogger(HybridEntryManagerFactory.class);
    @Inject
    private BaseFactoryService persistanceFactoryService;
    private String[] persistenceTypes;
    private Properties hybridMappingProperties;

    public String getPersistenceType() {
        return PERSISTENCE_TYPE;
    }

    public HashMap<String, String> getConfigurationFileNames(String alias) {
        String usedAlias = StringHelper.isEmpty((String)alias) ? "" : "-" + alias;
        HashMap<String, String> confs = new HashMap<String, String>();
        String confFileName = String.format(PROPERTIES_FILE, usedAlias);
        confs.put(PERSISTENCE_TYPE + usedAlias, confFileName);
        HashMap<String, String> allConfs = this.getAllConfigurationFileNames(alias, confFileName);
        confs.putAll(allConfs);
        return confs;
    }

    private HashMap<String, String> getAllConfigurationFileNames(String alias, String confFileName) {
        HashMap<String, String> allConfs = new HashMap<String, String>();
        FileConfiguration fileConf = new FileConfiguration(DIR + confFileName);
        if (!fileConf.isLoaded()) {
            LOG.error("Unable to load configuration file '{}'", (Object)(DIR + confFileName));
            throw new ConfigurationException(String.format("Unable to load configuration file: '%s'", fileConf));
        }
        String storagesList = fileConf.getString("storages", null);
        if (StringHelper.isEmpty((String)storagesList)) {
            throw new ConfigurationException("'storages' key not exists or value is empty!");
        }
        for (String persistenceType : this.persistenceTypes = StringHelper.split((String)storagesList, (String)",")) {
            PersistenceEntryManagerFactory persistenceEntryManagerFactory = this.persistanceFactoryService.getPersistenceEntryManagerFactory(persistenceType);
            if (persistenceEntryManagerFactory == null) {
                throw new ConfigurationException(String.format("Unable to get Persistence Entry Manager Factory by type '%s'", persistenceType));
            }
            String persistenceTypeAlias = this.persistanceFactoryService.getPersistenceTypeAlias(persistenceType);
            Map confs = persistenceEntryManagerFactory.getConfigurationFileNames(persistenceTypeAlias);
            allConfs.putAll(confs);
        }
        return allConfs;
    }

    public HybridEntryManager createEntryManager(Properties conf) {
        HashMap<String, PersistenceEntryManager> persistenceEntryManagers = new HashMap<String, PersistenceEntryManager>();
        ArrayList<PersistenceOperationService> operationServices = new ArrayList<PersistenceOperationService>();
        if (this.persistenceTypes == null) {
            Object hybridProperties = PropertiesHelper.findProperties((Properties)conf, (String)PERSISTENCE_TYPE, (String)"#");
            String storagesList = ((Properties)(hybridProperties = PropertiesHelper.filterProperties((Properties)hybridProperties, (String)"#"))).getProperty("storages", null);
            if (StringHelper.isEmpty((String)storagesList)) {
                throw new ConfigurationException("'storages' key not exists or value is empty!");
            }
            this.persistenceTypes = StringHelper.split((String)storagesList, (String)",");
        }
        for (String persistenceType : this.persistenceTypes) {
            PersistenceEntryManagerFactory persistenceEntryManagerFactory = this.persistanceFactoryService.getPersistenceEntryManagerFactory(persistenceType);
            if (persistenceEntryManagerFactory == null) {
                throw new ConfigurationException(String.format("Unable to get Persistence Entry Manager Factory by type '%s'", persistenceType));
            }
            Properties entryManagerConf = PropertiesHelper.findProperties((Properties)conf, (String)persistenceType, (String)"#");
            PersistenceEntryManager persistenceEntryManager = persistenceEntryManagerFactory.createEntryManager(entryManagerConf);
            persistenceEntryManagers.put(persistenceType, persistenceEntryManager);
            operationServices.add(persistenceEntryManager.getOperationService());
        }
        this.hybridMappingProperties = PropertiesHelper.filterProperties((Properties)conf, (String)"#");
        HybridPersistenceOperationService hybridOperationService = new HybridPersistenceOperationService(operationServices);
        HybridEntryManager hybridEntryManager = new HybridEntryManager(this.hybridMappingProperties, persistenceEntryManagers, hybridOperationService);
        LOG.info("Created HybridEntryManager: {}", (Object)hybridOperationService);
        return hybridEntryManager;
    }

    public void initStandalone(BaseFactoryService persistanceFactoryService) {
        this.persistanceFactoryService = persistanceFactoryService;
    }
}

