/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.deps.io.netty.handler.codec.memcache.binary;

import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.AbstractBinaryMemcacheDecoder;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.BinaryMemcacheResponse;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.DefaultBinaryMemcacheResponse;

public class BinaryMemcacheResponseDecoder
extends AbstractBinaryMemcacheDecoder<BinaryMemcacheResponse> {
    private static final byte FRAMING_MAGIC = 24;

    public BinaryMemcacheResponseDecoder() {
        this(8192);
    }

    public BinaryMemcacheResponseDecoder(int chunkSize) {
        super(chunkSize);
    }

    @Override
    protected BinaryMemcacheResponse decodeHeader(ByteBuf in) {
        DefaultBinaryMemcacheResponse header = new DefaultBinaryMemcacheResponse();
        header.setMagic(in.readByte());
        header.setOpcode(in.readByte());
        if (header.getMagic() == 24) {
            header.setFramingExtrasLength(in.readByte());
            header.setKeyLength(in.readByte());
        } else {
            header.setKeyLength(in.readShort());
        }
        header.setExtrasLength(in.readByte());
        header.setDataType(in.readByte());
        header.setStatus(in.readShort());
        header.setTotalBodyLength(in.readInt());
        header.setOpaque(in.readInt());
        header.setCAS(in.readLong());
        return header;
    }

    @Override
    protected BinaryMemcacheResponse buildInvalidMessage() {
        return new DefaultBinaryMemcacheResponse(new byte[0], Unpooled.EMPTY_BUFFER);
    }
}

