/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.utils.yasjl;

import com.couchbase.client.core.utils.yasjl.JsonStringByteBufProcessor;
import com.couchbase.client.deps.io.netty.buffer.ByteBufProcessor;

public class JsonObjectByteBufProcessor
implements ByteBufProcessor {
    private boolean isString;
    private int count;
    private final JsonStringByteBufProcessor stProcessor;

    public JsonObjectByteBufProcessor(JsonStringByteBufProcessor stProcessor) {
        this.stProcessor = stProcessor;
        this.reset();
    }

    public void reset() {
        this.count = 1;
        this.isString = false;
        this.stProcessor.reset();
    }

    @Override
    public boolean process(byte value) throws Exception {
        if (this.isString) {
            this.isString = this.stProcessor.process(value);
            return true;
        }
        switch (value) {
            case 123: {
                ++this.count;
                return true;
            }
            case 125: {
                --this.count;
                return this.count != 0;
            }
            case 34: {
                this.isString = true;
                return true;
            }
        }
        return true;
    }
}

