/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.client.uma;

import javax.ws.rs.core.UriBuilder;
import org.gluu.oxauth.client.service.ClientFactory;
import org.gluu.oxauth.client.uma.UmaMetadataService;
import org.gluu.oxauth.client.uma.UmaPermissionService;
import org.gluu.oxauth.client.uma.UmaResourceService;
import org.gluu.oxauth.client.uma.UmaRptIntrospectionService;
import org.gluu.oxauth.client.uma.UmaScopeService;
import org.gluu.oxauth.client.uma.UmaTokenService;
import org.gluu.oxauth.model.uma.UmaMetadata;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient43Engine;

public class UmaClientFactory {
    private static final UmaClientFactory instance = new UmaClientFactory();
    private ApacheHttpClient43Engine engine = ClientFactory.instance().createEngine(true);

    private UmaClientFactory() {
    }

    public static UmaClientFactory instance() {
        return instance;
    }

    public UmaResourceService createResourceService(UmaMetadata metadata) {
        return this.createResourceService(metadata, (ClientHttpEngine)this.engine);
    }

    public UmaResourceService createResourceService(UmaMetadata metadata, ClientHttpEngine engine) {
        ResteasyClient client = ((ResteasyClientBuilder)ResteasyClientBuilder.newBuilder()).httpEngine(engine).build();
        ResteasyWebTarget target = client.target(UriBuilder.fromPath((String)metadata.getResourceRegistrationEndpoint()));
        UmaResourceService proxy = (UmaResourceService)target.proxy(UmaResourceService.class);
        return proxy;
    }

    public UmaPermissionService createPermissionService(UmaMetadata metadata) {
        return this.createPermissionService(metadata, (ClientHttpEngine)this.engine);
    }

    public UmaPermissionService createPermissionService(UmaMetadata metadata, ClientHttpEngine engine) {
        ResteasyClient client = ((ResteasyClientBuilder)ResteasyClientBuilder.newBuilder()).httpEngine(engine).build();
        ResteasyWebTarget target = client.target(UriBuilder.fromPath((String)metadata.getPermissionEndpoint()));
        UmaPermissionService proxy = (UmaPermissionService)target.proxy(UmaPermissionService.class);
        return proxy;
    }

    public UmaRptIntrospectionService createRptStatusService(UmaMetadata metadata) {
        return this.createRptStatusService(metadata, (ClientHttpEngine)this.engine);
    }

    public UmaRptIntrospectionService createRptStatusService(UmaMetadata metadata, ClientHttpEngine engine) {
        ResteasyClient client = ((ResteasyClientBuilder)ResteasyClientBuilder.newBuilder()).httpEngine(engine).build();
        ResteasyWebTarget target = client.target(UriBuilder.fromPath((String)metadata.getIntrospectionEndpoint()));
        UmaRptIntrospectionService proxy = (UmaRptIntrospectionService)target.proxy(UmaRptIntrospectionService.class);
        return proxy;
    }

    public UmaMetadataService createMetadataService(String umaMetadataUri) {
        return this.createMetadataService(umaMetadataUri, (ClientHttpEngine)this.engine);
    }

    public UmaMetadataService createMetadataService(String umaMetadataUri, ClientHttpEngine engine) {
        ResteasyClient client = ((ResteasyClientBuilder)ResteasyClientBuilder.newBuilder()).httpEngine(engine).build();
        ResteasyWebTarget target = client.target(UriBuilder.fromPath((String)umaMetadataUri));
        UmaMetadataService proxy = (UmaMetadataService)target.proxy(UmaMetadataService.class);
        return proxy;
    }

    public UmaScopeService createScopeService(String scopeEndpointUri) {
        return this.createScopeService(scopeEndpointUri, (ClientHttpEngine)this.engine);
    }

    public UmaScopeService createScopeService(String scopeEndpointUri, ClientHttpEngine engine) {
        ResteasyClient client = ((ResteasyClientBuilder)ResteasyClientBuilder.newBuilder()).httpEngine(engine).build();
        ResteasyWebTarget target = client.target(UriBuilder.fromPath((String)scopeEndpointUri));
        UmaScopeService proxy = (UmaScopeService)target.proxy(UmaScopeService.class);
        return proxy;
    }

    public UmaTokenService createTokenService(UmaMetadata metadata) {
        return this.createTokenService(metadata, (ClientHttpEngine)this.engine);
    }

    public UmaTokenService createTokenService(UmaMetadata metadata, ClientHttpEngine engine) {
        ResteasyClient client = ((ResteasyClientBuilder)ResteasyClientBuilder.newBuilder()).httpEngine(engine).build();
        ResteasyWebTarget target = client.target(UriBuilder.fromPath((String)metadata.getTokenEndpoint()));
        UmaTokenService proxy = (UmaTokenService)target.proxy(UmaTokenService.class);
        return proxy;
    }

    public ResteasyClient newClient(ClientHttpEngine engine) {
        return ((ResteasyClientBuilder)ResteasyClientBuilder.newBuilder()).httpEngine(engine).build();
    }
}

