/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.client.ciba.push;

import org.apache.commons.lang.StringUtils;
import org.apache.http.entity.ContentType;
import org.gluu.oxauth.client.BaseRequest;
import org.gluu.oxauth.model.common.TokenType;
import org.json.JSONException;
import org.json.JSONObject;

public class PushTokenDeliveryRequest
extends BaseRequest {
    private String clientNotificationToken;
    private String authReqId;
    private String accessToken;
    private TokenType tokenType;
    private String refreshToken;
    private Integer expiresIn;
    private String idToken;

    public PushTokenDeliveryRequest() {
        this.setContentType(ContentType.APPLICATION_JSON.toString());
    }

    public String getClientNotificationToken() {
        return this.clientNotificationToken;
    }

    public void setClientNotificationToken(String clientNotificationToken) {
        this.clientNotificationToken = clientNotificationToken;
    }

    public String getAuthReqId() {
        return this.authReqId;
    }

    public void setAuthReqId(String authReqId) {
        this.authReqId = authReqId;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public TokenType getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(TokenType tokenType) {
        this.tokenType = tokenType;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public Integer getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    public String getIdToken() {
        return this.idToken;
    }

    public void setIdToken(String idToken) {
        this.idToken = idToken;
    }

    @Override
    public JSONObject getJSONParameters() throws JSONException {
        JSONObject parameters = new JSONObject();
        if (StringUtils.isNotBlank((String)this.authReqId)) {
            parameters.put("auth_req_id", (Object)this.authReqId);
        }
        if (StringUtils.isNotBlank((String)this.accessToken)) {
            parameters.put("access_token", (Object)this.accessToken);
        }
        if (this.tokenType != null) {
            parameters.put("token_type", (Object)this.tokenType.getName());
        }
        if (StringUtils.isNotBlank((String)this.refreshToken)) {
            parameters.put("refresh_token", (Object)this.refreshToken);
        }
        if (this.expiresIn != null) {
            parameters.put("expires_in", (Object)this.expiresIn);
        }
        if (StringUtils.isNotBlank((String)this.idToken)) {
            parameters.put("id_token", (Object)this.idToken);
        }
        return parameters;
    }

    @Override
    public String getQueryString() {
        String jsonQueryString = null;
        try {
            jsonQueryString = this.getJSONParameters().toString(4).replace("\\/", "/");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonQueryString;
    }
}

