/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.client.ciba.ping;

import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.log4j.Logger;
import org.gluu.oxauth.client.BaseClient;
import org.gluu.oxauth.client.ciba.ping.PingCallbackRequest;
import org.gluu.oxauth.client.ciba.ping.PingCallbackResponse;
import org.gluu.oxauth.util.ClientUtil;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient43Engine;
import org.json.JSONObject;

public class PingCallbackClient
extends BaseClient<PingCallbackRequest, PingCallbackResponse> {
    private static final Logger LOG = Logger.getLogger(PingCallbackClient.class);
    private final boolean fapiCompatibility;

    public PingCallbackClient(String url, boolean fapiCompatibility) {
        super(url);
        this.fapiCompatibility = fapiCompatibility;
    }

    @Override
    public String getHttpMethod() {
        return "POST";
    }

    public PingCallbackResponse exec() {
        if (this.fapiCompatibility) {
            this.setExecutor((ClientHttpEngine)this.getApacheHttpClient4ExecutorForMTLS());
        }
        this.initClientRequest();
        return this._exec();
    }

    private PingCallbackResponse _exec() {
        try {
            Invocation.Builder clientRequest = this.webTarget.request();
            this.applyCookies(clientRequest);
            clientRequest.header("Content-Type", (Object)((PingCallbackRequest)this.getRequest()).getContentType());
            if (StringUtils.isNotBlank((String)((PingCallbackRequest)this.getRequest()).getClientNotificationToken())) {
                clientRequest.header("Authorization", (Object)("Bearer " + ((PingCallbackRequest)this.getRequest()).getClientNotificationToken()));
            }
            JSONObject requestBody = ((PingCallbackRequest)this.getRequest()).getJSONParameters();
            this.clientResponse = clientRequest.buildPost(Entity.json((Object)requestBody.toString(4))).invoke();
            this.setResponse(new PingCallbackResponse(this.clientResponse));
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        return (PingCallbackResponse)this.getResponse();
    }

    private ApacheHttpClient43Engine getApacheHttpClient4ExecutorForMTLS() {
        String[] ciphers = new String[]{"TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384"};
        return new ApacheHttpClient43Engine((HttpClient)ClientUtil.createHttpClient("TLSv1.2", ciphers));
    }
}

