/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.client;

import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.client.BaseClient;
import org.gluu.oxauth.client.UserInfoRequest;
import org.gluu.oxauth.client.UserInfoResponse;
import org.gluu.oxauth.model.common.AuthorizationMethod;
import org.gluu.oxauth.model.crypto.OxAuthCryptoProvider;
import org.gluu.oxauth.model.jwe.Jwe;
import org.gluu.oxauth.model.jwt.Jwt;
import org.gluu.oxauth.model.userinfo.UserInfoErrorResponseType;
import org.gluu.oxauth.model.util.JwtUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UserInfoClient
extends BaseClient<UserInfoRequest, UserInfoResponse> {
    private String sharedKey;
    private PrivateKey privateKey;
    private String jwksUri;

    public UserInfoClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        if (((UserInfoRequest)this.request).getAuthorizationMethod() == null || ((UserInfoRequest)this.request).getAuthorizationMethod() == AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD || ((UserInfoRequest)this.request).getAuthorizationMethod() == AuthorizationMethod.URL_QUERY_PARAMETER) {
            return "GET";
        }
        return "POST";
    }

    public UserInfoResponse execUserInfo(String accessToken) {
        this.setRequest(new UserInfoRequest(accessToken));
        return this.exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserInfoResponse exec() {
        block30: {
            this.initClientRequest();
            Invocation.Builder clientRequest = null;
            if (((UserInfoRequest)this.getRequest()).getAuthorizationMethod() == null || ((UserInfoRequest)this.getRequest()).getAuthorizationMethod() == AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD) {
                if (StringUtils.isNotBlank((String)((UserInfoRequest)this.getRequest()).getAccessToken())) {
                    clientRequest = this.webTarget.request();
                    clientRequest.header("Authorization", (Object)("Bearer " + ((UserInfoRequest)this.getRequest()).getAccessToken()));
                }
            } else if (((UserInfoRequest)this.getRequest()).getAuthorizationMethod() == AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER) {
                if (StringUtils.isNotBlank((String)((UserInfoRequest)this.getRequest()).getAccessToken())) {
                    this.requestForm.param("access_token", ((UserInfoRequest)this.getRequest()).getAccessToken());
                }
            } else if (((UserInfoRequest)this.getRequest()).getAuthorizationMethod() == AuthorizationMethod.URL_QUERY_PARAMETER && StringUtils.isNotBlank((String)((UserInfoRequest)this.getRequest()).getAccessToken())) {
                this.addReqParam("access_token", ((UserInfoRequest)this.getRequest()).getAccessToken().toString());
            }
            if (clientRequest == null) {
                clientRequest = this.webTarget.request();
            }
            clientRequest.header("Content-Type", (Object)"application/x-www-form-urlencoded");
            try {
                if (((UserInfoRequest)this.getRequest()).getAuthorizationMethod() == null || ((UserInfoRequest)this.getRequest()).getAuthorizationMethod() == AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD || ((UserInfoRequest)this.getRequest()).getAuthorizationMethod() == AuthorizationMethod.URL_QUERY_PARAMETER) {
                    this.clientResponse = clientRequest.buildGet().invoke();
                } else if (((UserInfoRequest)this.getRequest()).getAuthorizationMethod() == AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER) {
                    this.clientResponse = clientRequest.buildPost(Entity.form((Form)this.requestForm)).invoke();
                }
                int status = this.clientResponse.getStatus();
                this.setResponse(new UserInfoResponse(status));
                String entity = (String)this.clientResponse.readEntity(String.class);
                ((UserInfoResponse)this.getResponse()).setEntity(entity);
                ((UserInfoResponse)this.getResponse()).setHeaders((MultivaluedMap<String, Object>)this.clientResponse.getMetadata());
                if (!StringUtils.isNotBlank((String)entity)) break block30;
                List contentType = (List)this.clientResponse.getHeaders().get((Object)"Content-Type");
                if (contentType != null && contentType.contains("application/jwt")) {
                    String[] jwtParts = entity.split("\\.");
                    if (jwtParts.length == 5) {
                        byte[] sharedSymmetricKey = this.sharedKey != null ? this.sharedKey.getBytes("UTF-8") : null;
                        Jwe jwe = Jwe.parse((String)entity, (PrivateKey)this.privateKey, (byte[])sharedSymmetricKey);
                        ((UserInfoResponse)this.getResponse()).setClaims(jwe.getClaims().toMap());
                    } else {
                        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
                        Jwt jwt = Jwt.parse((String)entity);
                        boolean signatureVerified = cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), jwt.getHeader().getKeyId(), JwtUtil.getJSONWebKeys((String)this.jwksUri), this.sharedKey, jwt.getHeader().getSignatureAlgorithm());
                        if (signatureVerified) {
                            ((UserInfoResponse)this.getResponse()).setClaims(jwt.getClaims().toMap());
                        }
                    }
                    break block30;
                }
                try {
                    JSONObject jsonObj = new JSONObject(entity);
                    if (jsonObj.has("error")) {
                        ((UserInfoResponse)this.getResponse()).setErrorType(UserInfoErrorResponseType.fromString((String)jsonObj.getString("error")));
                        jsonObj.remove("error");
                    }
                    if (jsonObj.has("error_description")) {
                        ((UserInfoResponse)this.getResponse()).setErrorDescription(jsonObj.getString("error_description"));
                        jsonObj.remove("error_description");
                    }
                    if (jsonObj.has("error_uri")) {
                        ((UserInfoResponse)this.getResponse()).setErrorUri(jsonObj.getString("error_uri"));
                        jsonObj.remove("error_uri");
                    }
                    Iterator iterator = jsonObj.keys();
                    while (iterator.hasNext()) {
                        String key = (String)iterator.next();
                        ArrayList<String> values = new ArrayList<String>();
                        JSONArray jsonArray = jsonObj.optJSONArray(key);
                        if (jsonArray != null) {
                            for (int i = 0; i < jsonArray.length(); ++i) {
                                String value = jsonArray.optString(i);
                                if (value == null) continue;
                                values.add(value);
                            }
                        } else {
                            String value = jsonObj.optString(key);
                            if (value != null) {
                                values.add(value);
                            }
                        }
                        ((UserInfoResponse)this.getResponse()).getClaims().put(key, values);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.closeConnection();
            }
        }
        return (UserInfoResponse)this.getResponse();
    }

    public void setSharedKey(String sharedKey) {
        this.sharedKey = sharedKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public String getJwksUri() {
        return this.jwksUri;
    }

    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }
}

