/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.client;

import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Form;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.gluu.oxauth.client.BaseClient;
import org.gluu.oxauth.client.ClientAuthnEnabler;
import org.gluu.oxauth.client.ClientAuthnRequest;
import org.gluu.oxauth.client.TokenRequest;
import org.gluu.oxauth.client.TokenResponse;
import org.gluu.oxauth.model.common.GrantType;

public class TokenClient
extends BaseClient<TokenRequest, TokenResponse> {
    private static final Logger LOG = Logger.getLogger(TokenClient.class);

    public TokenClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        return "POST";
    }

    public TokenResponse execAuthorizationCode(String code, String redirectUri, String clientId, String clientSecret) {
        this.setRequest(new TokenRequest(GrantType.AUTHORIZATION_CODE));
        ((TokenRequest)this.getRequest()).setCode(code);
        ((TokenRequest)this.getRequest()).setRedirectUri(redirectUri);
        ((TokenRequest)this.getRequest()).setAuthUsername(clientId);
        ((TokenRequest)this.getRequest()).setAuthPassword(clientSecret);
        return this.exec();
    }

    public TokenResponse execResourceOwnerPasswordCredentialsGrant(String username, String password, String scope, String clientId, String clientSecret) {
        this.setRequest(new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS));
        ((TokenRequest)this.getRequest()).setUsername(username);
        ((TokenRequest)this.getRequest()).setPassword(password);
        ((TokenRequest)this.getRequest()).setScope(scope);
        ((TokenRequest)this.getRequest()).setAuthUsername(clientId);
        ((TokenRequest)this.getRequest()).setAuthPassword(clientSecret);
        return this.exec();
    }

    public TokenResponse execClientCredentialsGrant(String scope, String clientId, String clientSecret) {
        this.setRequest(new TokenRequest(GrantType.CLIENT_CREDENTIALS));
        ((TokenRequest)this.getRequest()).setScope(scope);
        ((TokenRequest)this.getRequest()).setAuthUsername(clientId);
        ((TokenRequest)this.getRequest()).setAuthPassword(clientSecret);
        return this.exec();
    }

    public TokenResponse execExtensionGrant(String grantTypeUri, String assertion, String clientId, String clientSecret) {
        GrantType grantType = GrantType.fromString((String)grantTypeUri);
        this.setRequest(new TokenRequest(grantType));
        ((TokenRequest)this.getRequest()).setAssertion(assertion);
        ((TokenRequest)this.getRequest()).setAuthUsername(clientId);
        ((TokenRequest)this.getRequest()).setAuthPassword(clientSecret);
        return this.exec();
    }

    public TokenResponse execRefreshToken(String scope, String refreshToken, String clientId, String clientSecret) {
        this.setRequest(new TokenRequest(GrantType.REFRESH_TOKEN));
        ((TokenRequest)this.getRequest()).setScope(scope);
        ((TokenRequest)this.getRequest()).setRefreshToken(refreshToken);
        ((TokenRequest)this.getRequest()).setAuthUsername(clientId);
        ((TokenRequest)this.getRequest()).setAuthPassword(clientSecret);
        return this.exec();
    }

    public TokenResponse exec() {
        this.initClientRequest();
        if (((TokenRequest)this.getRequest()).getGrantType() != null) {
            this.requestForm.param("grant_type", ((TokenRequest)this.getRequest()).getGrantType().toString());
        }
        if (StringUtils.isNotBlank((String)((TokenRequest)this.getRequest()).getCode())) {
            this.requestForm.param("code", ((TokenRequest)this.getRequest()).getCode());
        }
        if (StringUtils.isNotBlank((String)((TokenRequest)this.getRequest()).getCodeVerifier())) {
            this.requestForm.param("code_verifier", ((TokenRequest)this.getRequest()).getCodeVerifier());
        }
        if (StringUtils.isNotBlank((String)((TokenRequest)this.getRequest()).getRedirectUri())) {
            this.requestForm.param("redirect_uri", ((TokenRequest)this.getRequest()).getRedirectUri());
        }
        if (StringUtils.isNotBlank((String)((TokenRequest)this.getRequest()).getUsername())) {
            this.requestForm.param("username", ((TokenRequest)this.getRequest()).getUsername());
        }
        if (StringUtils.isNotBlank((String)((TokenRequest)this.getRequest()).getPassword())) {
            this.requestForm.param("password", ((TokenRequest)this.getRequest()).getPassword());
        }
        if (StringUtils.isNotBlank((String)((TokenRequest)this.getRequest()).getScope())) {
            this.requestForm.param("scope", ((TokenRequest)this.getRequest()).getScope());
        }
        if (StringUtils.isNotBlank((String)((TokenRequest)this.getRequest()).getAssertion())) {
            this.requestForm.param("assertion", ((TokenRequest)this.getRequest()).getAssertion());
        }
        if (StringUtils.isNotBlank((String)((TokenRequest)this.getRequest()).getRefreshToken())) {
            this.requestForm.param("refresh_token", ((TokenRequest)this.getRequest()).getRefreshToken());
        }
        for (String key : ((TokenRequest)this.getRequest()).getCustomParameters().keySet()) {
            this.requestForm.param(key, ((TokenRequest)this.getRequest()).getCustomParameters().get(key));
        }
        if (StringUtils.isNotBlank((String)((TokenRequest)this.getRequest()).getAuthReqId())) {
            this.requestForm.param("auth_req_id", ((TokenRequest)this.getRequest()).getAuthReqId());
        }
        if (StringUtils.isNotBlank((String)((TokenRequest)this.getRequest()).getDeviceCode())) {
            this.requestForm.param("device_code", ((TokenRequest)this.getRequest()).getDeviceCode());
        }
        Invocation.Builder clientRequest = this.webTarget.request();
        this.applyCookies(clientRequest);
        new ClientAuthnEnabler(clientRequest, this.requestForm).exec((ClientAuthnRequest)this.request);
        clientRequest.header("Content-Type", (Object)((TokenRequest)this.request).getContentType());
        try {
            this.clientResponse = clientRequest.buildPost(Entity.form((Form)this.requestForm)).invoke();
            TokenResponse tokenResponse = new TokenResponse(this.clientResponse);
            tokenResponse.injectDataFromJson();
            this.setResponse(tokenResponse);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        return (TokenResponse)this.getResponse();
    }
}

