/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.client;

import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.gluu.oxauth.client.BaseResponseWithErrors;
import org.gluu.oxauth.model.common.GrantType;
import org.gluu.oxauth.model.common.ResponseType;
import org.gluu.oxauth.model.register.RegisterErrorResponseType;
import org.gluu.oxauth.model.register.RegisterRequestParam;
import org.gluu.oxauth.model.register.RegisterResponseParam;
import org.gluu.oxauth.model.util.Util;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RegisterResponse
extends BaseResponseWithErrors<RegisterErrorResponseType> {
    private static final Logger LOG = Logger.getLogger(RegisterResponse.class);
    private String clientId;
    private String clientSecret;
    private String registrationAccessToken;
    private String registrationClientUri;
    private Date clientIdIssuedAt;
    private Date clientSecretExpiresAt;
    private List<ResponseType> responseTypes;
    private List<GrantType> grantTypes;
    private Map<String, String> claims = new HashMap<String, String>();

    public RegisterResponse() {
    }

    public RegisterResponse(Response clientResponse) {
        super(clientResponse);
        this.injectDataFromJson(this.entity);
    }

    @Override
    public RegisterErrorResponseType fromString(String p_string) {
        return RegisterErrorResponseType.fromString((String)p_string);
    }

    public void injectDataFromJson() {
        this.injectDataFromJson(this.getEntity());
    }

    public static RegisterResponse valueOf(String p_json) {
        RegisterResponse r = new RegisterResponse();
        r.injectDataFromJson(p_json);
        return r;
    }

    @Override
    public void injectDataFromJson(String p_json) {
        if (StringUtils.isNotBlank((String)p_json)) {
            try {
                JSONObject jsonObj = new JSONObject(p_json);
                if (jsonObj.has(RegisterResponseParam.CLIENT_ID.toString())) {
                    this.setClientId(jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString()));
                    jsonObj.remove(RegisterResponseParam.CLIENT_ID.toString());
                }
                if (jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString())) {
                    this.setClientSecret(jsonObj.getString(RegisterResponseParam.CLIENT_SECRET.toString()));
                    jsonObj.remove(RegisterResponseParam.CLIENT_SECRET.toString());
                }
                if (jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString())) {
                    this.setRegistrationAccessToken(jsonObj.getString(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
                    jsonObj.remove(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString());
                }
                if (jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString())) {
                    this.setRegistrationClientUri(jsonObj.getString(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
                    jsonObj.remove(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString());
                }
                if (jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString())) {
                    long clientIdIssuedAt = jsonObj.getLong(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString());
                    if (clientIdIssuedAt > 0L) {
                        this.setClientIdIssuedAt(new Date(clientIdIssuedAt * 1000L));
                    }
                    jsonObj.remove(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString());
                }
                if (jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString())) {
                    long clientSecretExpiresAt = jsonObj.getLong(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString());
                    if (clientSecretExpiresAt > 0L) {
                        this.setClientSecretExpiresAt(new Date(clientSecretExpiresAt * 1000L));
                    }
                    jsonObj.remove(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString());
                }
                if (jsonObj.has(RegisterRequestParam.RESPONSE_TYPES.toString())) {
                    JSONArray responseTypesJsonArray = jsonObj.getJSONArray(RegisterRequestParam.RESPONSE_TYPES.toString());
                    this.responseTypes = Util.asEnumList((JSONArray)responseTypesJsonArray, ResponseType.class);
                }
                if (jsonObj.has(RegisterRequestParam.GRANT_TYPES.toString())) {
                    JSONArray grantTypesJsonArray = jsonObj.getJSONArray(RegisterRequestParam.GRANT_TYPES.toString());
                    this.grantTypes = Util.asEnumList((JSONArray)grantTypesJsonArray, GrantType.class);
                }
                Iterator it = jsonObj.keys();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    this.getClaims().put(key, String.valueOf(jsonObj.get(key)));
                }
            }
            catch (JSONException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getRegistrationAccessToken() {
        return this.registrationAccessToken;
    }

    public void setRegistrationAccessToken(String registrationAccessToken) {
        this.registrationAccessToken = registrationAccessToken;
    }

    public String getRegistrationClientUri() {
        return this.registrationClientUri;
    }

    public void setRegistrationClientUri(String registrationClientUri) {
        this.registrationClientUri = registrationClientUri;
    }

    public Date getClientIdIssuedAt() {
        return this.clientIdIssuedAt != null ? new Date(this.clientIdIssuedAt.getTime()) : null;
    }

    public void setClientIdIssuedAt(Date clientIdIssuedAt) {
        this.clientIdIssuedAt = clientIdIssuedAt != null ? new Date(clientIdIssuedAt.getTime()) : null;
    }

    public Date getClientSecretExpiresAt() {
        return this.clientSecretExpiresAt != null ? new Date(this.clientSecretExpiresAt.getTime()) : null;
    }

    public void setClientSecretExpiresAt(Date clientSecretExpiresAt) {
        this.clientSecretExpiresAt = clientSecretExpiresAt != null ? new Date(clientSecretExpiresAt.getTime()) : null;
    }

    public List<ResponseType> getResponseTypes() {
        return this.responseTypes;
    }

    public void setResponseTypes(List<ResponseType> responseTypes) {
        this.responseTypes = responseTypes;
    }

    public List<GrantType> getGrantTypes() {
        return this.grantTypes;
    }

    public void setGrantTypes(List<GrantType> grantTypes) {
        this.grantTypes = grantTypes;
    }

    public Map<String, String> getClaims() {
        return this.claims;
    }

    public void setClaims(Map<String, String> claims) {
        this.claims = claims;
    }
}

