/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.client;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.gluu.oxauth.client.BaseClient;
import org.gluu.oxauth.client.GluuConfigurationRequest;
import org.gluu.oxauth.client.GluuConfigurationResponse;
import org.json.JSONArray;
import org.json.JSONObject;

public class GluuConfigurationClient
extends BaseClient<GluuConfigurationRequest, GluuConfigurationResponse> {
    private static final Logger LOG = Logger.getLogger(GluuConfigurationClient.class);

    public GluuConfigurationClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        return "GET";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GluuConfigurationResponse execGluuConfiguration() {
        this.initClientRequest();
        this.setRequest(new GluuConfigurationRequest());
        Invocation.Builder clientRequest = this.webTarget.request();
        this.applyCookies(clientRequest);
        clientRequest.header("Content-Type", (Object)"application/json");
        try {
            this.clientResponse = clientRequest.buildGet().invoke();
            this.setResponse(new GluuConfigurationResponse());
            String entity = (String)this.clientResponse.readEntity(String.class);
            ((GluuConfigurationResponse)this.getResponse()).setEntity(entity);
            ((GluuConfigurationResponse)this.getResponse()).setHeaders((MultivaluedMap<String, Object>)this.clientResponse.getMetadata());
            ((GluuConfigurationResponse)this.getResponse()).setStatus(this.clientResponse.getStatus());
            if (StringUtils.isNotBlank((String)entity)) {
                JSONObject jsonObj = new JSONObject(entity);
                if (jsonObj.has("id_generation_endpoint")) {
                    ((GluuConfigurationResponse)this.getResponse()).setIdGenerationEndpoint(jsonObj.getString("id_generation_endpoint"));
                }
                if (jsonObj.has("introspection_endpoint")) {
                    ((GluuConfigurationResponse)this.getResponse()).setIntrospectionEndpoint(jsonObj.getString("introspection_endpoint"));
                }
                if (jsonObj.has("auth_level_mapping")) {
                    ((GluuConfigurationResponse)this.getResponse()).setAuthLevelMapping(this.mapJsonToAuthLevelMapping(jsonObj.getJSONObject("auth_level_mapping")));
                }
                if (jsonObj.has("scope_to_claims_mapping")) {
                    ((GluuConfigurationResponse)this.getResponse()).setScopeToClaimsMapping(this.mapJsonToScopeToClaimsMapping(jsonObj.getJSONObject("scope_to_claims_mapping")));
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        return (GluuConfigurationResponse)this.getResponse();
    }

    private Map<Integer, Set<String>> mapJsonToAuthLevelMapping(JSONObject jsonObject) {
        HashMap<Integer, Set<String>> authLevelMapping = new HashMap<Integer, Set<String>>();
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            try {
                String key = (String)keys.next();
                Integer level = new Integer(key);
                authLevelMapping.put(level, new HashSet());
                JSONArray jsonArray = jsonObject.getJSONArray(key);
                for (int i = 0; i < jsonArray.length(); ++i) {
                    ((Set)authLevelMapping.get(level)).add(jsonArray.getString(i));
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return authLevelMapping;
    }

    private Map<String, Set<String>> mapJsonToScopeToClaimsMapping(JSONObject jsonObject) {
        HashMap<String, Set<String>> scopeToClaimsMapping = new HashMap<String, Set<String>>();
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            try {
                String scope = (String)keys.next();
                scopeToClaimsMapping.put(scope, new HashSet());
                JSONArray jsonArray = jsonObject.getJSONArray(scope);
                for (int i = 0; i < jsonArray.length(); ++i) {
                    ((Set)scopeToClaimsMapping.get(scope)).add(jsonArray.getString(i));
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return scopeToClaimsMapping;
    }
}

