/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.client;

import java.util.ArrayList;
import java.util.Iterator;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.gluu.oxauth.client.BaseClient;
import org.gluu.oxauth.client.ClientInfoRequest;
import org.gluu.oxauth.client.ClientInfoResponse;
import org.gluu.oxauth.model.common.AuthorizationMethod;
import org.gluu.oxauth.model.userinfo.UserInfoErrorResponseType;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ClientInfoClient
extends BaseClient<ClientInfoRequest, ClientInfoResponse> {
    private static final Logger LOG = Logger.getLogger(ClientInfoClient.class);

    public ClientInfoClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        if (((ClientInfoRequest)this.getRequest()).getAuthorizationMethod() == null || ((ClientInfoRequest)this.getRequest()).getAuthorizationMethod() == AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD || ((ClientInfoRequest)this.getRequest()).getAuthorizationMethod() == AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER) {
            return "POST";
        }
        return "GET";
    }

    public ClientInfoResponse execClientInfo(String accessToken) {
        this.setRequest(new ClientInfoRequest(accessToken));
        return this.exec();
    }

    public ClientInfoResponse exec() {
        this.initClientRequest();
        return this._exec();
    }

    @Deprecated
    public ClientInfoResponse exec(ClientHttpEngine engine) {
        this.resteasyClient = ((ResteasyClientBuilder)ResteasyClientBuilder.newBuilder()).httpEngine(engine).build();
        this.webTarget = this.resteasyClient.target(this.getUrl());
        return this._exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientInfoResponse _exec() {
        block23: {
            Invocation.Builder clientRequest = null;
            if (((ClientInfoRequest)this.getRequest()).getAuthorizationMethod() == null || ((ClientInfoRequest)this.getRequest()).getAuthorizationMethod() == AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD) {
                if (StringUtils.isNotBlank((String)((ClientInfoRequest)this.getRequest()).getAccessToken())) {
                    clientRequest = this.webTarget.request();
                    clientRequest.header("Authorization", (Object)("Bearer " + ((ClientInfoRequest)this.getRequest()).getAccessToken()));
                }
            } else if (((ClientInfoRequest)this.getRequest()).getAuthorizationMethod() == AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER) {
                if (StringUtils.isNotBlank((String)((ClientInfoRequest)this.getRequest()).getAccessToken())) {
                    this.requestForm.param("access_token", ((ClientInfoRequest)this.getRequest()).getAccessToken());
                }
            } else if (((ClientInfoRequest)this.getRequest()).getAuthorizationMethod() == AuthorizationMethod.URL_QUERY_PARAMETER && StringUtils.isNotBlank((String)((ClientInfoRequest)this.getRequest()).getAccessToken())) {
                this.addReqParam("access_token", ((ClientInfoRequest)this.getRequest()).getAccessToken());
            }
            if (clientRequest == null) {
                clientRequest = this.webTarget.request();
            }
            clientRequest.header("Content-Type", (Object)"application/x-www-form-urlencoded");
            try {
                this.clientResponse = ((ClientInfoRequest)this.getRequest()).getAuthorizationMethod() == null || ((ClientInfoRequest)this.getRequest()).getAuthorizationMethod() == AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD || ((ClientInfoRequest)this.getRequest()).getAuthorizationMethod() == AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER ? clientRequest.buildPost(Entity.form((Form)this.requestForm)).invoke() : clientRequest.buildGet().invoke();
                int status = this.clientResponse.getStatus();
                this.setResponse(new ClientInfoResponse(status));
                String entity = (String)this.clientResponse.readEntity(String.class);
                ((ClientInfoResponse)this.getResponse()).setEntity(entity);
                ((ClientInfoResponse)this.getResponse()).setHeaders((MultivaluedMap<String, Object>)this.clientResponse.getMetadata());
                if (!StringUtils.isNotBlank((String)entity)) break block23;
                try {
                    JSONObject jsonObj = new JSONObject(entity);
                    if (jsonObj.has("error")) {
                        ((ClientInfoResponse)this.getResponse()).setErrorType(UserInfoErrorResponseType.fromString((String)jsonObj.getString("error")));
                        jsonObj.remove("error");
                    }
                    if (jsonObj.has("error_description")) {
                        ((ClientInfoResponse)this.getResponse()).setErrorDescription(jsonObj.getString("error_description"));
                        jsonObj.remove("error_description");
                    }
                    if (jsonObj.has("error_uri")) {
                        ((ClientInfoResponse)this.getResponse()).setErrorUri(jsonObj.getString("error_uri"));
                        jsonObj.remove("error_uri");
                    }
                    Iterator iterator = jsonObj.keys();
                    while (iterator.hasNext()) {
                        String key = (String)iterator.next();
                        ArrayList<String> values = new ArrayList<String>();
                        JSONArray jsonArray = jsonObj.optJSONArray(key);
                        if (jsonArray != null) {
                            for (int i = 0; i < jsonArray.length(); ++i) {
                                String value = jsonArray.optString(i);
                                if (value == null) continue;
                                values.add(value);
                            }
                        } else {
                            String value = jsonObj.optString(key);
                            if (value != null) {
                                values.add(value);
                            }
                        }
                        ((ClientInfoResponse)this.getResponse()).getClaims().put(key, values);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                this.closeConnection();
            }
        }
        return (ClientInfoResponse)this.getResponse();
    }
}

