/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.client;

import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Form;
import org.apache.log4j.Logger;
import org.gluu.oxauth.client.ClientAuthnRequest;
import org.gluu.oxauth.model.common.AuthenticationMethod;
import org.gluu.oxauth.model.token.ClientAssertionType;

public class ClientAuthnEnabler {
    private static final Logger LOG = Logger.getLogger(ClientAuthnEnabler.class);
    private Invocation.Builder clientRequest;
    private Form requestForm;

    public ClientAuthnEnabler(Invocation.Builder clientRequest, Form requestForm) {
        this.clientRequest = clientRequest;
        this.requestForm = requestForm;
    }

    public void exec(ClientAuthnRequest request) {
        if (request.getAuthenticationMethod() == AuthenticationMethod.CLIENT_SECRET_BASIC && request.hasCredentials()) {
            this.clientRequest.header("Authorization", (Object)("Basic " + request.getEncodedCredentials()));
            return;
        }
        if (request.getAuthenticationMethod() == AuthenticationMethod.CLIENT_SECRET_POST) {
            if (request.getAuthUsername() != null && !request.getAuthUsername().isEmpty()) {
                this.requestForm.param("client_id", request.getAuthUsername());
            }
            if (request.getAuthPassword() != null && !request.getAuthPassword().isEmpty()) {
                this.requestForm.param("client_secret", request.getAuthPassword());
            }
            return;
        }
        if (request.getAuthenticationMethod() == AuthenticationMethod.CLIENT_SECRET_JWT || request.getAuthenticationMethod() == AuthenticationMethod.PRIVATE_KEY_JWT) {
            this.requestForm.param("client_assertion_type", ClientAssertionType.JWT_BEARER.toString());
            if (request.getClientAssertion() != null) {
                this.requestForm.param("client_assertion", request.getClientAssertion());
            }
            if (request.getAuthUsername() != null && !request.getAuthUsername().isEmpty()) {
                this.requestForm.param("client_id", request.getAuthUsername());
            }
        }
    }
}

