/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.gluu.oxauth.client.AuthorizationRequest;
import org.gluu.oxauth.client.BaseRequest;
import org.gluu.oxauth.client.BaseResponse;
import org.gluu.oxauth.client.RegisterRequest;
import org.gluu.oxauth.client.UserInfoRequest;
import org.gluu.oxauth.model.common.AuthenticationMethod;
import org.gluu.oxauth.model.common.AuthorizationMethod;
import org.gluu.oxauth.model.common.HasParamName;
import org.gluu.oxauth.model.util.Util;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;

public abstract class BaseClient<T extends BaseRequest, V extends BaseResponse> {
    private static final Logger LOG = Logger.getLogger(BaseClient.class);
    private String url;
    protected T request;
    protected V response;
    protected ResteasyClient resteasyClient = null;
    protected WebTarget webTarget = null;
    protected Form requestForm = new Form();
    protected Response clientResponse = null;
    private final List<Cookie> cookies = new ArrayList<Cookie>();
    private final Map<String, String> headers = new HashMap<String, String>();
    protected ClientHttpEngine executor = null;

    public BaseClient() {
    }

    public BaseClient(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public T getRequest() {
        return this.request;
    }

    public void setRequest(T request) {
        this.request = request;
    }

    public V getResponse() {
        return this.response;
    }

    public void setResponse(V response) {
        this.response = response;
    }

    public ClientHttpEngine getExecutor() {
        return this.executor;
    }

    public void setExecutor(ClientHttpEngine executor) {
        this.executor = executor;
    }

    protected void addReqParam(String p_key, HasParamName p_value) {
        if (p_value != null) {
            this.addReqParam(p_key, p_value.getParamName());
        }
    }

    protected void addReqParam(String p_key, String p_value) {
        if (Util.allNotBlank((String[])new String[]{p_key, p_value})) {
            if (((BaseRequest)this.request).getAuthorizationMethod() == AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER) {
                this.requestForm.param(p_key, p_value);
            } else {
                this.webTarget = this.webTarget.queryParam(p_key, new Object[]{p_value});
            }
        }
    }

    public String getRequestAsString() {
        StringBuilder sb = new StringBuilder();
        try {
            URL theUrl = new URL(this.url);
            if (this.getHttpMethod().equals("POST") || this.getHttpMethod().equals("PUT") || this.getHttpMethod().equals("DELETE")) {
                AuthorizationRequest authorizationRequest;
                sb.append(this.getHttpMethod()).append(" ").append(theUrl.getPath()).append(" HTTP/1.1");
                if (StringUtils.isNotBlank((String)((BaseRequest)this.request).getContentType())) {
                    sb.append("\n");
                    sb.append("Content-Type: ").append(((BaseRequest)this.request).getContentType());
                }
                if (StringUtils.isNotBlank((String)((BaseRequest)this.request).getMediaType())) {
                    sb.append("\n");
                    sb.append("Accept: ").append(((BaseRequest)this.request).getMediaType());
                }
                sb.append("\n");
                sb.append("Host: ").append(theUrl.getHost());
                if (this.request instanceof AuthorizationRequest && (authorizationRequest = (AuthorizationRequest)this.request).isUseNoRedirectHeader()) {
                    sb.append("\n");
                    sb.append(AuthorizationRequest.NO_REDIRECT_HEADER + ": true");
                }
                if (((BaseRequest)this.request).getAuthorizationMethod() == null) {
                    if ((((BaseRequest)this.request).getAuthenticationMethod() == null || ((BaseRequest)this.request).getAuthenticationMethod() == AuthenticationMethod.CLIENT_SECRET_BASIC) && ((BaseRequest)this.request).hasCredentials()) {
                        String encodedCredentials = ((BaseRequest)this.request).getEncodedCredentials();
                        sb.append("\n");
                        sb.append("Authorization: Basic ").append(encodedCredentials);
                    }
                } else if (((BaseRequest)this.request).getAuthorizationMethod() == AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD && this.request instanceof UserInfoRequest) {
                    String accessToken = ((UserInfoRequest)this.request).getAccessToken();
                    sb.append("\n");
                    sb.append("Authorization: Bearer ").append(accessToken);
                }
                sb.append("\n");
                sb.append("\n");
                sb.append(((BaseRequest)this.request).getQueryString());
            } else if (this.getHttpMethod().equals("GET")) {
                AuthorizationRequest authorizationRequest;
                sb.append(this.getHttpMethod()).append(" ").append(theUrl.getPath()).append(" HTTP/1.1");
                if (StringUtils.isNotBlank((String)((BaseRequest)this.request).getQueryString())) {
                    sb.append("?").append(((BaseRequest)this.request).getQueryString());
                }
                sb.append(" HTTP/1.1");
                sb.append("\n");
                sb.append("Host: ").append(theUrl.getHost());
                if (this.request instanceof AuthorizationRequest && (authorizationRequest = (AuthorizationRequest)this.request).isUseNoRedirectHeader()) {
                    sb.append("\n");
                    sb.append(AuthorizationRequest.NO_REDIRECT_HEADER + ": true");
                }
                if (((BaseRequest)this.request).getAuthorizationMethod() == null) {
                    if (((BaseRequest)this.request).hasCredentials()) {
                        String encodedCredentials = ((BaseRequest)this.request).getEncodedCredentials();
                        sb.append("\n");
                        sb.append("Authorization: Basic ").append(encodedCredentials);
                    } else if (this.request instanceof RegisterRequest) {
                        RegisterRequest r = (RegisterRequest)this.request;
                        String registrationAccessToken = r.getRegistrationAccessToken();
                        sb.append("\n");
                        sb.append("Authorization: Bearer ").append(registrationAccessToken);
                    }
                } else if (((BaseRequest)this.request).getAuthorizationMethod() == AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD && this.request instanceof UserInfoRequest) {
                    String accessToken = ((UserInfoRequest)this.request).getAccessToken();
                    sb.append("\n");
                    sb.append("Authorization: Bearer ").append(accessToken);
                }
            }
        }
        catch (MalformedURLException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return sb.toString();
    }

    public String getResponseAsString() {
        StringBuilder sb = new StringBuilder();
        if (this.response != null) {
            sb.append("HTTP/1.1 ").append(((BaseResponse)this.response).getStatus());
            if (((BaseResponse)this.response).getHeaders() != null) {
                for (String key : ((BaseResponse)this.response).getHeaders().keySet()) {
                    sb.append("\n").append(key).append(": ").append(((List)((BaseResponse)this.response).getHeaders().get((Object)key)).get(0));
                }
            }
            if (((BaseResponse)this.response).getEntity() != null) {
                sb.append("\n");
                sb.append("\n");
                sb.append(((BaseResponse)this.response).getEntity());
            }
        }
        return sb.toString();
    }

    protected void initClientRequest() {
        this.resteasyClient = this.executor == null ? (ResteasyClient)ResteasyClientBuilder.newClient() : ((ResteasyClientBuilder)ResteasyClientBuilder.newBuilder()).httpEngine(this.executor).build();
        this.webTarget = this.resteasyClient.target(this.getUrl());
    }

    protected void applyCookies(Invocation.Builder clientRequest) {
        for (Cookie cookie : this.cookies) {
            clientRequest.cookie(cookie);
        }
        for (Map.Entry entry : this.headers.entrySet()) {
            clientRequest.header((String)entry.getKey(), entry.getValue());
        }
    }

    public void closeConnection() {
        try {
            if (this.clientResponse != null) {
                this.clientResponse.close();
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public abstract String getHttpMethod();

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }
}

