/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.model.attribute;

import java.util.HashMap;
import java.util.Map;
import org.gluu.persist.annotation.AttributeEnum;

public enum AttributeDataType implements AttributeEnum
{
    STRING("string", "Text"),
    NUMERIC("numeric", "Numeric"),
    BOOLEAN("boolean", "Boolean"),
    BINARY("binary", "Binary"),
    CERTIFICATE("certificate", "Certificate"),
    DATE("generalizedTime", "Date");

    private String value;
    private String displayName;
    private static Map<String, AttributeDataType> MAP_BY_VALUES;

    private AttributeDataType(String value, String displayName) {
        this.value = value;
        this.displayName = displayName;
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static AttributeDataType getByValue(String value) {
        return MAP_BY_VALUES.get(value);
    }

    public Enum<? extends AttributeEnum> resolveByValue(String value) {
        return AttributeDataType.getByValue(value);
    }

    public String toString() {
        return this.value;
    }

    static {
        MAP_BY_VALUES = new HashMap<String, AttributeDataType>();
        for (AttributeDataType enumType : AttributeDataType.values()) {
            MAP_BY_VALUES.put(enumType.getValue(), enumType);
        }
    }
}

