/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.persist.ldap.impl;

import com.unboundid.ldap.sdk.LDAPException;
import javax.enterprise.context.ApplicationScoped;
import org.gluu.orm.util.ArrayHelper;
import org.gluu.persist.exception.operation.SearchException;
import org.gluu.search.filter.Filter;
import org.gluu.search.filter.FilterType;

@ApplicationScoped
public class LdapFilterConverter {
    public com.unboundid.ldap.sdk.Filter convertToLdapFilter(Filter genericFilter) throws SearchException {
        FilterType type = genericFilter.getType();
        if (FilterType.RAW == type) {
            try {
                return com.unboundid.ldap.sdk.Filter.create((String)genericFilter.getFilterString());
            }
            catch (LDAPException ex) {
                throw new SearchException("Failed to parse RAW Ldap filter", (Throwable)ex, ex.getResultCode().intValue());
            }
        }
        if (FilterType.NOT == type || FilterType.AND == type || FilterType.OR == type) {
            Filter[] genericFilters = genericFilter.getFilters();
            com.unboundid.ldap.sdk.Filter[] ldapFilters = new com.unboundid.ldap.sdk.Filter[genericFilters.length];
            if (genericFilters != null) {
                for (int i = 0; i < genericFilters.length; ++i) {
                    ldapFilters[i] = this.convertToLdapFilter(genericFilters[i]);
                }
                if (FilterType.NOT == type) {
                    return com.unboundid.ldap.sdk.Filter.createNOTFilter((com.unboundid.ldap.sdk.Filter)ldapFilters[0]);
                }
                if (FilterType.AND == type) {
                    return com.unboundid.ldap.sdk.Filter.createANDFilter((com.unboundid.ldap.sdk.Filter[])ldapFilters);
                }
                if (FilterType.OR == type) {
                    return com.unboundid.ldap.sdk.Filter.createORFilter((com.unboundid.ldap.sdk.Filter[])ldapFilters);
                }
            }
        }
        if (FilterType.EQUALITY == type) {
            String attributeName = ArrayHelper.isEmpty((Object[])genericFilter.getFilters()) ? genericFilter.getAttributeName() : this.convertToLdapFilter(genericFilter.getFilters()[0]).getAttributeName();
            return com.unboundid.ldap.sdk.Filter.createEqualityFilter((String)attributeName, (String)String.valueOf(genericFilter.getAssertionValue()));
        }
        if (FilterType.LESS_OR_EQUAL == type) {
            return com.unboundid.ldap.sdk.Filter.createLessOrEqualFilter((String)genericFilter.getAttributeName(), (String)String.valueOf(genericFilter.getAssertionValue()));
        }
        if (FilterType.GREATER_OR_EQUAL == type) {
            return com.unboundid.ldap.sdk.Filter.createGreaterOrEqualFilter((String)genericFilter.getAttributeName(), (String)String.valueOf(genericFilter.getAssertionValue()));
        }
        if (FilterType.PRESENCE == type) {
            return com.unboundid.ldap.sdk.Filter.createPresenceFilter((String)genericFilter.getAttributeName());
        }
        if (FilterType.APPROXIMATE_MATCH == type) {
            return com.unboundid.ldap.sdk.Filter.createApproximateMatchFilter((String)genericFilter.getAttributeName(), (String)String.valueOf(genericFilter.getAssertionValue()));
        }
        if (FilterType.SUBSTRING == type) {
            return com.unboundid.ldap.sdk.Filter.createSubstringFilter((String)genericFilter.getAttributeName(), (String)genericFilter.getSubInitial(), (String[])genericFilter.getSubAny(), (String)genericFilter.getSubFinal());
        }
        if (FilterType.LOWERCASE == type) {
            return com.unboundid.ldap.sdk.Filter.createPresenceFilter((String)genericFilter.getAttributeName());
        }
        throw new SearchException(String.format("Unknown filter type '%s'", type), 2);
    }

    public Filter convertRawLdapFilterToFilter(String rawFilter) throws SearchException {
        com.unboundid.ldap.sdk.Filter ldapFilter;
        try {
            ldapFilter = com.unboundid.ldap.sdk.Filter.create((String)rawFilter);
        }
        catch (LDAPException ex) {
            throw new SearchException("Failed to parse RAW Ldap filter", (Throwable)ex, ex.getResultCode().intValue());
        }
        return this.convertRawLdapFilterToFilterImpl(ldapFilter);
    }

    protected Filter convertRawLdapFilterToFilterImpl(com.unboundid.ldap.sdk.Filter ldapFilter) throws SearchException {
        byte type = ldapFilter.getFilterType();
        if (-94 == type || -96 == type || -95 == type) {
            com.unboundid.ldap.sdk.Filter[] ldapFilters = ldapFilter.getComponents();
            Filter[] genericFilters = new Filter[ldapFilters.length];
            if (ldapFilters != null) {
                for (int i = 0; i < ldapFilters.length; ++i) {
                    genericFilters[i] = this.convertRawLdapFilterToFilterImpl(ldapFilters[i]);
                }
                if (-94 == type) {
                    return Filter.createNOTFilter((Filter)genericFilters[0]);
                }
                if (-96 == type) {
                    return Filter.createANDFilter((Filter[])genericFilters);
                }
                if (-95 == type) {
                    return Filter.createORFilter((Filter[])genericFilters);
                }
            }
        }
        if (-93 == type) {
            return Filter.createEqualityFilter((String)ldapFilter.getAttributeName(), (Object)ldapFilter.getAssertionValue());
        }
        if (-90 == type) {
            return Filter.createLessOrEqualFilter((String)ldapFilter.getAttributeName(), (Object)ldapFilter.getAssertionValue());
        }
        if (-91 == type) {
            return Filter.createGreaterOrEqualFilter((String)ldapFilter.getAttributeName(), (Object)ldapFilter.getAssertionValue());
        }
        if (-121 == type) {
            return Filter.createPresenceFilter((String)ldapFilter.getAttributeName());
        }
        if (-88 == type) {
            return Filter.createApproximateMatchFilter((String)ldapFilter.getAttributeName(), (String)ldapFilter.getAssertionValue());
        }
        if (-92 == type) {
            return Filter.createSubstringFilter((String)ldapFilter.getAttributeName(), (String)ldapFilter.getSubInitialString(), (String[])ldapFilter.getSubAnyStrings(), (String)ldapFilter.getSubFinalString());
        }
        throw new SearchException(String.format("Unknown filter type '%s'", type), 2);
    }
}

