/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.persist.reflect.property;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gluu.orm.util.StringHelper;
import org.gluu.persist.exception.PropertyNotFoundException;
import org.gluu.persist.reflect.property.PropertyAnnotationResolver;
import org.gluu.persist.reflect.util.ReflectHelper;

public class BasicPropertyAnnotationResolver
implements PropertyAnnotationResolver {
    @Override
    public List<Annotation> getClassAnnotations(Class<?> theClass, Class<?> ... allowedAnnotations) {
        List<Annotation> result = this.getOnlyAllowedAnntotations(theClass.getAnnotations(), allowedAnnotations);
        Class<?> superClass = theClass.getSuperclass();
        while (ReflectHelper.isNotPrimitiveClass(superClass)) {
            result.addAll(this.getOnlyAllowedAnntotations(superClass.getAnnotations(), allowedAnnotations));
            superClass = superClass.getSuperclass();
        }
        return result;
    }

    @Override
    public List<Annotation> getPropertyAnnotations(Class<?> theClass, String propertyName, Class<?> ... allowedAnnotations) throws PropertyNotFoundException {
        if (StringHelper.isEmpty((String)propertyName)) {
            throw new PropertyNotFoundException("Could not find property " + propertyName + " in class " + theClass.getName());
        }
        Class<?> thisClass = theClass;
        while (ReflectHelper.isNotPrimitiveClass(thisClass)) {
            Field[] fileds;
            for (Field filed : fileds = thisClass.getDeclaredFields()) {
                if (!propertyName.equals(filed.getName())) continue;
                return this.getOnlyAllowedAnntotations(filed.getAnnotations(), allowedAnnotations);
            }
            thisClass = thisClass.getSuperclass();
        }
        throw new PropertyNotFoundException("Could not find property " + propertyName + " in class " + theClass.getName());
    }

    @Override
    public Map<String, List<Annotation>> getPropertiesAnnotations(Class<?> theClass, Class<?> ... allowedAnnotations) {
        HashMap<String, List<Annotation>> result = new HashMap<String, List<Annotation>>();
        Class<?> thisClass = theClass;
        while (ReflectHelper.isNotPrimitiveClass(thisClass)) {
            Field[] fields;
            for (Field field : fields = thisClass.getDeclaredFields()) {
                List<Annotation> annotations = this.getOnlyAllowedAnntotations(field.getAnnotations(), allowedAnnotations);
                if (annotations == null || annotations.size() == 0) continue;
                result.put(field.getName(), annotations);
            }
            thisClass = thisClass.getSuperclass();
        }
        return result;
    }

    private List<Annotation> getOnlyAllowedAnntotations(Annotation[] annotations, Class<?>[] allowedAnnotations) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        if (annotations.length == 0) {
            return result;
        }
        for (Annotation annotation : annotations) {
            for (Class<?> allowedAnnotation : allowedAnnotations) {
                if (!annotation.annotationType().equals(allowedAnnotation)) continue;
                result.add(annotation);
            }
        }
        return result;
    }
}

