/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.persist.impl;

import org.gluu.orm.util.StringHelper;
import org.gluu.persist.exception.KeyConversionException;
import org.gluu.persist.impl.model.ParsedKey;

public class GenericKeyConverter {
    private boolean useAllRdn;

    public GenericKeyConverter() {
        this.useAllRdn = true;
    }

    public GenericKeyConverter(boolean useAllRdn) {
        this.useAllRdn = useAllRdn;
    }

    public ParsedKey convertToKey(String dn) {
        String key;
        if (StringHelper.isEmpty((String)dn)) {
            throw new KeyConversionException("Failed to convert empty DN to Key");
        }
        StringBuilder result = new StringBuilder();
        String[] tokens = dn.split(",");
        String orgInum = null;
        String attributeName = null;
        for (String token : tokens) {
            int pos = token.indexOf("=");
            if (pos == -1) {
                throw new KeyConversionException("Failed to convert empty DN to Key");
            }
            String name = token.substring(0, pos);
            if (attributeName == null) {
                attributeName = name;
            }
            String value = token.substring(pos + 1, token.length());
            if (StringHelper.equalsIgnoreCase((String)name, (String)"o")) {
                if (StringHelper.equalsIgnoreCase((String)value, (String)"gluu")) continue;
                orgInum = value;
                continue;
            }
            result.insert(0, "_" + value);
            if (!this.useAllRdn) break;
        }
        key = (key = result.toString()).length() == 0 ? "_" : key.substring(1);
        return new ParsedKey(key, attributeName, orgInum);
    }
}

