/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.orm.couchbase.impl;

import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.env.DefaultCouchbaseEnvironment;
import java.util.HashMap;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import org.gluu.orm.couchbase.impl.CouchbaseEntryManager;
import org.gluu.orm.couchbase.operation.impl.CouchbaseConnectionProvider;
import org.gluu.orm.couchbase.operation.impl.CouchbaseOperationServiceImpl;
import org.gluu.orm.util.PropertiesHelper;
import org.gluu.orm.util.StringHelper;
import org.gluu.orm.util.init.Initializable;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.PersistenceEntryManagerFactory;
import org.gluu.persist.exception.operation.ConfigurationException;
import org.gluu.persist.service.BaseFactoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class CouchbaseEntryManagerFactory
extends Initializable
implements PersistenceEntryManagerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CouchbaseEntryManagerFactory.class);
    public static final String PERSISTENCE_TYPE = PersistenceEntryManager.PERSITENCE_TYPES.couchbase.name();
    public static final String PROPERTIES_FILE = "gluu-couchbase%s.properties";
    private DefaultCouchbaseEnvironment.Builder builder;
    private CouchbaseEnvironment couchbaseEnvironment;
    private Properties couchbaseConnectionProperties;

    @PostConstruct
    public void create() {
        this.builder = (DefaultCouchbaseEnvironment.Builder)DefaultCouchbaseEnvironment.builder().operationTracingEnabled(false);
    }

    @PreDestroy
    public void destroy() {
        if (this.couchbaseEnvironment != null) {
            boolean result = this.couchbaseEnvironment.shutdown();
            this.resetInitialized();
            LOG.info("Couchbase environment are destroyed with result: {}", (Object)result);
        }
    }

    protected void initInternal() {
        String keepAliveIntervalString;
        String keepAliveTimeoutString;
        String computationPoolSizeString;
        String mutationTokensEnabledString;
        String operationTracingEnabledString;
        boolean useSSL = Boolean.valueOf(this.couchbaseConnectionProperties.getProperty("ssl.trustStore.enable"));
        if (useSSL) {
            String sslTrustStoreFile = this.couchbaseConnectionProperties.getProperty("ssl.trustStore.file");
            String sslTrustStorePin = this.couchbaseConnectionProperties.getProperty("ssl.trustStore.pin");
            ((DefaultCouchbaseEnvironment.Builder)((DefaultCouchbaseEnvironment.Builder)this.builder.sslEnabled(true)).sslTruststoreFile(sslTrustStoreFile)).sslTruststorePassword(sslTrustStorePin);
            LOG.info("Configuring builder to enable SSL support");
        } else {
            this.builder.sslEnabled(false);
            LOG.info("Configuring builder to disable SSL support");
        }
        String connectTimeoutString = this.couchbaseConnectionProperties.getProperty("connection.connect-timeout");
        if (StringHelper.isNotEmpty((String)connectTimeoutString)) {
            int connectTimeout = Integer.valueOf(connectTimeoutString);
            this.builder.connectTimeout((long)connectTimeout);
            LOG.info("Configuring builder to override connectTimeout from properties");
        }
        if (StringHelper.isNotEmpty((String)(operationTracingEnabledString = this.couchbaseConnectionProperties.getProperty("connection.operation-tracing-enabled")))) {
            boolean operationTracingEnabled = Boolean.valueOf(operationTracingEnabledString);
            this.builder.operationTracingEnabled(operationTracingEnabled);
            LOG.info("Configuring builder to override operationTracingEnabled from properties");
        }
        if (StringHelper.isNotEmpty((String)(mutationTokensEnabledString = this.couchbaseConnectionProperties.getProperty("connection.mutation-tokens-enabled")))) {
            boolean mutationTokensEnabled = Boolean.valueOf(mutationTokensEnabledString);
            this.builder.mutationTokensEnabled(mutationTokensEnabled);
            LOG.info("Configuring builder to override mutationTokensEnabled from properties");
        }
        if (StringHelper.isNotEmpty((String)(computationPoolSizeString = this.couchbaseConnectionProperties.getProperty("connection.computation-pool-size")))) {
            int computationPoolSize = Integer.valueOf(computationPoolSizeString);
            this.builder.computationPoolSize(computationPoolSize);
            LOG.info("Configuring builder to override computationPoolSize from properties");
        }
        if (StringHelper.isNotEmpty((String)(keepAliveTimeoutString = this.couchbaseConnectionProperties.getProperty("connection.keep-alive-timeout")))) {
            long keepAliveTimeout = Integer.valueOf(keepAliveTimeoutString).intValue();
            this.builder.keepAliveTimeout(keepAliveTimeout);
            LOG.info("Configuring builder to override keepAliveTimeout from properties");
        }
        if (StringHelper.isNotEmpty((String)(keepAliveIntervalString = this.couchbaseConnectionProperties.getProperty("connection.keep-alive-interval")))) {
            long keepAliveInterval = Integer.valueOf(keepAliveIntervalString).intValue();
            this.builder.keepAliveInterval(keepAliveInterval);
            LOG.info("Configuring builder to override keepAliveInterval from properties");
        }
        this.couchbaseEnvironment = this.builder.build();
        this.builder = null;
    }

    public String getPersistenceType() {
        return PERSISTENCE_TYPE;
    }

    public HashMap<String, String> getConfigurationFileNames(String alias) {
        String usedAlias = StringHelper.isEmpty((String)alias) ? "" : "." + alias;
        HashMap<String, String> confs = new HashMap<String, String>();
        String confFileName = String.format(PROPERTIES_FILE, usedAlias);
        confs.put(PERSISTENCE_TYPE + usedAlias, confFileName);
        return confs;
    }

    public CouchbaseEnvironment getCouchbaseEnvironment() {
        return this.couchbaseEnvironment;
    }

    public CouchbaseEntryManager createEntryManager(Properties conf) {
        Properties entryManagerConf = PropertiesHelper.filterProperties((Properties)conf, (String)"#");
        if (this.couchbaseConnectionProperties == null) {
            this.couchbaseConnectionProperties = entryManagerConf;
        }
        this.init();
        if (!this.isInitialized()) {
            throw new ConfigurationException("Failed to create Couchbase environment!");
        }
        CouchbaseConnectionProvider connectionProvider = new CouchbaseConnectionProvider(entryManagerConf, this.couchbaseEnvironment);
        connectionProvider.create();
        if (!connectionProvider.isCreated()) {
            throw new ConfigurationException(String.format("Failed to create Couchbase connection pool! Result code: '%s'", connectionProvider.getCreationResultCode()));
        }
        LOG.debug("Created connectionProvider '{}' with code '{}'", (Object)connectionProvider, (Object)connectionProvider.getCreationResultCode());
        CouchbaseEntryManager couchbaseEntryManager = new CouchbaseEntryManager(new CouchbaseOperationServiceImpl(entryManagerConf, connectionProvider));
        LOG.info("Created CouchbaseEntryManager: {}", (Object)couchbaseEntryManager.getOperationService());
        return couchbaseEntryManager;
    }

    public void initStandalone(BaseFactoryService persistanceFactoryService) {
        this.builder = (DefaultCouchbaseEnvironment.Builder)((DefaultCouchbaseEnvironment.Builder)DefaultCouchbaseEnvironment.builder().mutationTokensEnabled(true)).computationPoolSize(5);
    }
}

