/*
 * Decompiled with CFR 0.152.
 */
package org.tinyradius.dictionary;

import java.util.HashMap;
import java.util.Map;
import org.tinyradius.dictionary.AttributeType;
import org.tinyradius.dictionary.WritableDictionary;

public class MemoryDictionary
implements WritableDictionary {
    private Map vendorsByCode = new HashMap();
    private Map attributesByCode = new HashMap();
    private Map attributesByName = new HashMap();

    @Override
    public AttributeType getAttributeTypeByCode(int typeCode) {
        return this.getAttributeTypeByCode(-1, typeCode);
    }

    @Override
    public AttributeType getAttributeTypeByCode(int vendorCode, int typeCode) {
        Map vendorAttributes = (Map)this.attributesByCode.get(new Integer(vendorCode));
        if (vendorAttributes == null) {
            return null;
        }
        return (AttributeType)vendorAttributes.get(new Integer(typeCode));
    }

    @Override
    public AttributeType getAttributeTypeByName(String typeName) {
        return (AttributeType)this.attributesByName.get(typeName);
    }

    @Override
    public int getVendorId(String vendorName) {
        for (Map.Entry e : this.vendorsByCode.entrySet()) {
            if (!e.getValue().equals(vendorName)) continue;
            return (Integer)e.getKey();
        }
        return -1;
    }

    @Override
    public String getVendorName(int vendorId) {
        return (String)this.vendorsByCode.get(new Integer(vendorId));
    }

    @Override
    public void addVendor(int vendorId, String vendorName) {
        if (vendorId < 0) {
            throw new IllegalArgumentException("vendor ID must be positive");
        }
        if (this.getVendorName(vendorId) != null) {
            throw new IllegalArgumentException("duplicate vendor code");
        }
        if (vendorName == null || vendorName.length() == 0) {
            throw new IllegalArgumentException("vendor name empty");
        }
        this.vendorsByCode.put(new Integer(vendorId), vendorName);
    }

    @Override
    public void addAttributeType(AttributeType attributeType) {
        if (attributeType == null) {
            throw new IllegalArgumentException("attribute type must not be null");
        }
        Integer vendorId = new Integer(attributeType.getVendorId());
        Integer typeCode = new Integer(attributeType.getTypeCode());
        String attributeName = attributeType.getName();
        if (this.attributesByName.containsKey(attributeName)) {
            throw new IllegalArgumentException("duplicate attribute name: " + attributeName);
        }
        HashMap<Integer, AttributeType> vendorAttributes = (HashMap<Integer, AttributeType>)this.attributesByCode.get(vendorId);
        if (vendorAttributes == null) {
            vendorAttributes = new HashMap<Integer, AttributeType>();
            this.attributesByCode.put(vendorId, vendorAttributes);
        }
        if (vendorAttributes.containsKey(typeCode)) {
            throw new IllegalArgumentException("duplicate type code: " + typeCode);
        }
        this.attributesByName.put(attributeName, attributeType);
        vendorAttributes.put(typeCode, attributeType);
    }
}

