/*
 * Decompiled with CFR 0.152.
 */
package org.tinyradius.attribute;

import inet.ipaddr.AddressStringException;
import inet.ipaddr.AddressValueException;
import inet.ipaddr.IPAddressString;
import inet.ipaddr.ipv6.IPv6Address;
import java.util.Arrays;
import org.tinyradius.attribute.RadiusAttribute;
import org.tinyradius.util.RadiusException;

public class Ipv6PrefixAttribute
extends RadiusAttribute {
    public Ipv6PrefixAttribute() {
    }

    public Ipv6PrefixAttribute(int type, String value) {
        this.setAttributeType(type);
        this.setAttributeValue(value);
    }

    @Override
    public String getAttributeValue() {
        byte[] data = this.getAttributeData();
        if (data == null) {
            throw new RuntimeException("ipv6 prefix attribute: expected 2-18 bytes attribute data and got null.");
        }
        if (data.length < 2 || data.length > 18) {
            throw new RuntimeException("ipv6 prefix attribute: expected 2-18 bytes attribute data and got " + data.length);
        }
        try {
            int prefixSize = data[1] & 0xFF;
            byte[] prefix = Arrays.copyOfRange(data, 2, data.length);
            if (prefix.length < 16) {
                prefix = Arrays.copyOf(prefix, 16);
            }
            IPv6Address ipv6prefix = new IPv6Address(prefix, Integer.valueOf(prefixSize));
            return ipv6prefix.toString();
        }
        catch (AddressValueException e) {
            throw new IllegalArgumentException("bad IPv6 prefix", e);
        }
    }

    @Override
    public void setAttributeValue(String value) {
        if (value == null || value.length() < 3) {
            throw new IllegalArgumentException("bad IPv6 address : " + value);
        }
        try {
            IPAddressString ipAddressString = new IPAddressString(value);
            if (!ipAddressString.isIPAddress() || !ipAddressString.isIPv6()) {
                throw new IllegalArgumentException("bad IPv6 address : " + value);
            }
            IPv6Address ipv6Prefix = ipAddressString.toAddress().toIPv6();
            byte[] data = new byte[18];
            data[0] = 0;
            data[1] = (byte)(ipv6Prefix.getPrefixLength() & 0xFF);
            byte[] ipData = ipv6Prefix.getNetworkSection().getBytes();
            for (int i = 0; i < ipData.length; ++i) {
                data[i + 2] = ipData[i];
            }
            this.setAttributeData(data);
        }
        catch (AddressStringException e) {
            throw new IllegalArgumentException("bad IPv6 address : " + value, e);
        }
    }

    @Override
    public void readAttribute(byte[] data, int offset, int length) throws RadiusException {
        if (length > 20 || length < 4) {
            throw new RadiusException("IPv6 prefix attribute: expected 4-20 bytes data");
        }
        super.readAttribute(data, offset, length);
    }
}

