/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.persist.sql.operation.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.querydsl.core.QueryException;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.core.types.dsl.Wildcard;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.gluu.orm.util.ArrayHelper;
import org.gluu.orm.util.StringHelper;
import org.gluu.persist.exception.MappingException;
import org.gluu.persist.exception.extension.PersistenceExtension;
import org.gluu.persist.exception.operation.DeleteException;
import org.gluu.persist.exception.operation.DuplicateEntryException;
import org.gluu.persist.exception.operation.EntryConvertationException;
import org.gluu.persist.exception.operation.EntryNotFoundException;
import org.gluu.persist.exception.operation.PersistenceException;
import org.gluu.persist.exception.operation.SearchException;
import org.gluu.persist.model.AttributeData;
import org.gluu.persist.model.AttributeDataModification;
import org.gluu.persist.model.BatchOperation;
import org.gluu.persist.model.EntryData;
import org.gluu.persist.model.PagedResult;
import org.gluu.persist.model.SearchScope;
import org.gluu.persist.operation.auth.PasswordEncryptionHelper;
import org.gluu.persist.operation.auth.PasswordEncryptionMethod;
import org.gluu.persist.sql.impl.SqlBatchOperationWraper;
import org.gluu.persist.sql.model.ConvertedExpression;
import org.gluu.persist.sql.model.JsonAttributeValue;
import org.gluu.persist.sql.model.SearchReturnDataType;
import org.gluu.persist.sql.model.TableMapping;
import org.gluu.persist.sql.operation.SqlOperationService;
import org.gluu.persist.sql.operation.impl.SqlConnectionProvider;
import org.gluu.persist.sql.operation.watch.OperationDurationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlOperationServiceImpl
implements SqlOperationService {
    private static final Logger LOG = LoggerFactory.getLogger(SqlOperationServiceImpl.class);
    private static final ObjectMapper JSON_OBJECT_MAPPER = new ObjectMapper();
    private Properties props;
    private SqlConnectionProvider connectionProvider;
    private boolean disableAttributeMapping = false;
    private PersistenceExtension persistenceExtension;
    private SQLQueryFactory sqlQueryFactory;
    private String schemaName;
    private Path<String> docAlias = ExpressionUtils.path(String.class, (String)"doc");

    private SqlOperationServiceImpl() {
    }

    public SqlOperationServiceImpl(Properties props, SqlConnectionProvider connectionProvider) {
        this.props = props;
        this.connectionProvider = connectionProvider;
        this.init();
    }

    private void init() {
        this.sqlQueryFactory = this.connectionProvider.getSqlQueryFactory();
        this.schemaName = this.connectionProvider.getSchemaName();
    }

    @Override
    public SqlConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    public boolean authenticate(String key, String password, String objectClass) throws SearchException {
        return this.authenticateImpl(key, password, objectClass);
    }

    private boolean authenticateImpl(String key, String password, String objectClass) throws SearchException {
        Instant startTime = OperationDurationUtil.instance().now();
        boolean result = false;
        if (password != null) {
            try {
                List<AttributeData> attributes = this.lookup(key, objectClass, "userPassword");
                Object userPasswordObj = null;
                for (AttributeData attribute : attributes) {
                    if (!StringHelper.equalsIgnoreCase((String)attribute.getName(), (String)"userPassword")) continue;
                    userPasswordObj = attribute.getValue();
                }
                String userPassword = null;
                if (userPasswordObj instanceof String) {
                    userPassword = (String)userPasswordObj;
                }
                if (userPassword != null) {
                    result = this.persistenceExtension == null ? PasswordEncryptionHelper.compareCredentials((String)password, (String)userPassword) : this.persistenceExtension.compareHashedPasswords(password, userPassword);
                }
            }
            catch (EntryConvertationException ex) {
                throw new SearchException(String.format("Failed to get '%s' attribute", "userPassword"), (Throwable)ex);
            }
        }
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        TableMapping tableMapping = this.connectionProvider.getTableMappingByKey(key, objectClass);
        OperationDurationUtil.instance().logDebug("SQL operation: bind, duration: {}, table: {}, key: {}", new Object[]{duration, tableMapping.getTableName(), key});
        return result;
    }

    @Override
    public boolean addEntry(String key, String objectClass, Collection<AttributeData> attributes) throws DuplicateEntryException, PersistenceException {
        Instant startTime = OperationDurationUtil.instance().now();
        TableMapping tableMapping = this.connectionProvider.getTableMappingByKey(key, objectClass);
        boolean result = this.addEntryImpl(tableMapping, key, attributes);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("SQL operation: add, duration: {}, table: {}, key: {}, attributes: {}", new Object[]{duration, tableMapping.getTableName(), key, attributes});
        return result;
    }

    private boolean addEntryImpl(TableMapping tableMapping, String key, Collection<AttributeData> attributes) throws PersistenceException {
        try {
            Map<String, String> columTypes = tableMapping.getColumTypes();
            RelationalPathBase<Object> tableRelationalPath = this.buildTableRelationalPath(tableMapping);
            SQLInsertClause sqlInsertQuery = this.sqlQueryFactory.insert(tableRelationalPath);
            for (AttributeData attribute : attributes) {
                String attributeType = columTypes.get(attribute.getName().toLowerCase());
                boolean multiValued = attributeType != null && this.isJsonColumn(tableMapping.getTableName(), attributeType);
                sqlInsertQuery.columns(new Path[]{Expressions.stringPath((String)attribute.getName())});
                if (multiValued || Boolean.TRUE.equals(attribute.getMultiValued())) {
                    sqlInsertQuery.values(new Object[]{this.convertValueToDbJson(attribute.getValues())});
                    continue;
                }
                sqlInsertQuery.values(new Object[]{attribute.getValue()});
            }
            long rowInserted = sqlInsertQuery.execute();
            return rowInserted == 1L;
        }
        catch (QueryException ex) {
            throw new PersistenceException("Failed to add entry", (Throwable)ex);
        }
    }

    @Override
    public boolean updateEntry(String key, String objectClass, List<AttributeDataModification> mods) throws UnsupportedOperationException, PersistenceException {
        Instant startTime = OperationDurationUtil.instance().now();
        TableMapping tableMapping = this.connectionProvider.getTableMappingByKey(key, objectClass);
        boolean result = this.updateEntryImpl(tableMapping, key, mods);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("SQL operation: modify, duration: {}, table: {}, key: {}, mods: {}", new Object[]{duration, tableMapping.getTableName(), key, mods});
        return result;
    }

    private boolean updateEntryImpl(TableMapping tableMapping, String key, List<AttributeDataModification> mods) throws PersistenceException {
        try {
            Map<String, String> columTypes = tableMapping.getColumTypes();
            RelationalPathBase<Object> tableRelationalPath = this.buildTableRelationalPath(tableMapping);
            SQLUpdateClause sqlUpdateQuery = this.sqlQueryFactory.update(tableRelationalPath);
            for (AttributeDataModification attributeMod : mods) {
                AttributeData attribute = attributeMod.getAttribute();
                StringPath path = Expressions.stringPath((String)attribute.getName());
                String attributeType = columTypes.get(attribute.getName().toLowerCase());
                boolean multiValued = attributeType != null && this.isJsonColumn(tableMapping.getTableName(), attributeType);
                AttributeDataModification.AttributeModificationType type = attributeMod.getModificationType();
                if (AttributeDataModification.AttributeModificationType.ADD == type || AttributeDataModification.AttributeModificationType.FORCE_UPDATE == type) {
                    if (multiValued || Boolean.TRUE.equals(attribute.getMultiValued())) {
                        sqlUpdateQuery.set((Path)path, (Object)this.convertValueToDbJson(attribute.getValues()));
                        continue;
                    }
                    sqlUpdateQuery.set((Path)path, attribute.getValue());
                    continue;
                }
                if (AttributeDataModification.AttributeModificationType.REPLACE == type) {
                    if (multiValued || Boolean.TRUE.equals(attribute.getMultiValued())) {
                        sqlUpdateQuery.set((Path)path, (Object)this.convertValueToDbJson(attribute.getValues()));
                        continue;
                    }
                    sqlUpdateQuery.set((Path)path, attribute.getValue());
                    continue;
                }
                if (AttributeDataModification.AttributeModificationType.REMOVE == type) {
                    sqlUpdateQuery.setNull((Path)path);
                    continue;
                }
                throw new UnsupportedOperationException("Operation type '" + type + "' is not implemented");
            }
            Predicate whereExp = ExpressionUtils.eq((Expression)Expressions.stringPath((String)"doc_id"), (Expression)Expressions.constant((Object)key));
            long rowInserted = ((SQLUpdateClause)sqlUpdateQuery.where(whereExp)).execute();
            return rowInserted == 1L;
        }
        catch (QueryException ex) {
            throw new PersistenceException("Failed to update entry", (Throwable)ex);
        }
    }

    @Override
    public boolean delete(String key, String objectClass) throws EntryNotFoundException {
        Instant startTime = OperationDurationUtil.instance().now();
        TableMapping tableMapping = this.connectionProvider.getTableMappingByKey(key, objectClass);
        boolean result = this.deleteImpl(tableMapping, key);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("SQL operation: delete, duration: {}, table: {}, key: {}", new Object[]{duration, tableMapping.getTableName(), key});
        return result;
    }

    private boolean deleteImpl(TableMapping tableMapping, String key) throws EntryNotFoundException {
        try {
            RelationalPathBase<Object> tableRelationalPath = this.buildTableRelationalPath(tableMapping);
            SQLDeleteClause sqlDeleteQuery = this.sqlQueryFactory.delete(tableRelationalPath);
            Predicate exp = ExpressionUtils.eq((Expression)Expressions.stringPath((String)"doc_id"), (Expression)Expressions.constant((Object)key));
            sqlDeleteQuery.where(exp);
            long rowDeleted = sqlDeleteQuery.execute();
            return rowDeleted == 1L;
        }
        catch (QueryException ex) {
            throw new EntryNotFoundException("Failed to delete entry", (Throwable)ex);
        }
    }

    @Override
    public long delete(String key, String objectClass, ConvertedExpression expression, int count) throws DeleteException {
        Instant startTime = OperationDurationUtil.instance().now();
        TableMapping tableMapping = this.connectionProvider.getTableMappingByKey(key, objectClass);
        long result = this.deleteImpl(tableMapping, expression, count);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("SQL operation: delete_search, duration: {}, table: {}, key: {}, expression: {}, count: {}", new Object[]{duration, tableMapping.getTableName(), key, expression, count});
        return result;
    }

    private long deleteImpl(TableMapping tableMapping, ConvertedExpression expression, int count) throws DeleteException {
        try {
            RelationalPathBase<Object> tableRelationalPath = this.buildTableRelationalPath(tableMapping);
            SQLDeleteClause sqlDeleteQuery = this.sqlQueryFactory.delete(tableRelationalPath);
            Predicate exp = (Predicate)expression.expression();
            sqlDeleteQuery.where(exp);
            if (count > 0) {
                sqlDeleteQuery = (SQLDeleteClause)sqlDeleteQuery.limit((long)count);
            }
            long rowDeleted = sqlDeleteQuery.execute();
            return rowDeleted;
        }
        catch (QueryException ex) {
            throw new DeleteException(String.format("Failed to delete entries. Expression: '%s'", expression.expression()), (Throwable)ex);
        }
    }

    @Override
    public boolean deleteRecursively(String key, String objectClass) throws EntryNotFoundException, SearchException {
        Instant startTime = OperationDurationUtil.instance().now();
        TableMapping tableMapping = this.connectionProvider.getTableMappingByKey(key, objectClass);
        boolean result = this.deleteRecursivelyImpl(tableMapping, key);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("SQL operation: delete_tree, duration: {}, table: {}, key: {}", new Object[]{duration, tableMapping.getTableName(), key});
        return result;
    }

    private boolean deleteRecursivelyImpl(TableMapping tableMapping, String key) throws SearchException, EntryNotFoundException {
        LOG.warn("Removing only base key without sub-tree. Table: {}, Key: {}", (Object)tableMapping.getTableName(), (Object)key);
        return this.deleteImpl(tableMapping, key);
    }

    @Override
    public List<AttributeData> lookup(String key, String objectClass, String ... attributes) throws SearchException, EntryConvertationException {
        Instant startTime = OperationDurationUtil.instance().now();
        TableMapping tableMapping = this.connectionProvider.getTableMappingByKey(key, objectClass);
        List<AttributeData> result = this.lookupImpl(tableMapping, key, attributes);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("SQL operation: lookup, duration: {}, table: {}, key: {}, attributes: {}", new Object[]{duration, tableMapping.getTableName(), key, attributes});
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<AttributeData> lookupImpl(TableMapping tableMapping, String key, String ... attributes) throws SearchException, EntryConvertationException {
        try {
            RelationalPathBase<Object> tableRelationalPath = this.buildTableRelationalPath(tableMapping);
            Predicate whereExp = ExpressionUtils.eq((Expression)Expressions.stringPath((String)"doc_id"), (Expression)Expressions.constant((Object)key));
            Expression<?> attributesExp = this.buildSelectAttributes(attributes);
            SQLQuery sqlSelectQuery = (SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.select(attributesExp).from(tableRelationalPath)).where(whereExp)).limit(1L);
            try (ResultSet resultSet = sqlSelectQuery.getResults();){
                List<AttributeData> result = this.getAttributeDataList(tableMapping, resultSet, true);
                if (result == null) throw new SearchException(String.format("Failed to lookup entry by key: '%s'", key));
                List<AttributeData> list = result;
                return list;
            }
        }
        catch (QueryException | SQLException ex) {
            throw new SearchException(String.format("Failed to lookup query by key: '%s'", key), ex);
        }
    }

    @Override
    public <O> PagedResult<EntryData> search(String key, String objectClass, ConvertedExpression expression, SearchScope scope, String[] attributes, OrderSpecifier<?>[] orderBy, SqlBatchOperationWraper<O> batchOperationWraper, SearchReturnDataType returnDataType, int start, int count, int pageSize) throws SearchException {
        Instant startTime = OperationDurationUtil.instance().now();
        TableMapping tableMapping = this.connectionProvider.getTableMappingByKey(key, objectClass);
        PagedResult<EntryData> result = this.searchImpl(tableMapping, key, expression, scope, attributes, orderBy, batchOperationWraper, returnDataType, start, count, pageSize);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("SQL operation: search, duration: {}, table: {}, key: {}, expression: {}, scope: {}, attributes: {}, orderBy: {}, batchOperationWraper: {}, returnDataType: {}, start: {}, count: {}, pageSize: {}", new Object[]{duration, tableMapping.getTableName(), key, expression, scope, attributes, orderBy, batchOperationWraper, returnDataType, start, count, pageSize});
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <O> PagedResult<EntryData> searchImpl(TableMapping tableMapping, String key, ConvertedExpression expression, SearchScope scope, String[] attributes, OrderSpecifier<?>[] orderBy, SqlBatchOperationWraper<O> batchOperationWraper, SearchReturnDataType returnDataType, int start, int count, int pageSize) throws SearchException {
        SQLQuery sqlCountSelectQuery;
        String queryStr;
        LinkedList<EntryData> searchResultList;
        RelationalPathBase<Object> tableRelationalPath;
        block45: {
            SQLQuery sqlSelectQuery;
            BatchOperation<O> batchOperation = null;
            if (batchOperationWraper != null) {
                batchOperation = batchOperationWraper.getBatchOperation();
            }
            tableRelationalPath = this.buildTableRelationalPath(tableMapping);
            Expression<?> attributesExp = this.buildSelectAttributes(attributes);
            if (expression == null) {
                sqlSelectQuery = (SQLQuery)this.sqlQueryFactory.select(attributesExp).from(tableRelationalPath);
            } else {
                Predicate whereExp = (Predicate)expression.expression();
                sqlSelectQuery = (SQLQuery)((SQLQuery)this.sqlQueryFactory.select(attributesExp).from(tableRelationalPath)).where(whereExp);
            }
            SQLQuery baseQuery = sqlSelectQuery;
            if (orderBy != null) {
                baseQuery = (SQLQuery)sqlSelectQuery.orderBy(orderBy);
            }
            searchResultList = new LinkedList<EntryData>();
            queryStr = null;
            if (SearchReturnDataType.SEARCH == returnDataType || SearchReturnDataType.SEARCH_COUNT == returnDataType) {
                List<EntryData> lastResult = null;
                if (pageSize > 0) {
                    ResultSet resultSet = null;
                    try {
                        int currentLimit;
                        int resultCount = 0;
                        int lastCountRows = 0;
                        do {
                            boolean collectSearchResult = true;
                            currentLimit = pageSize;
                            if (count > 0) {
                                currentLimit = Math.min(pageSize, count - resultCount);
                            }
                            SQLQuery query = (SQLQuery)((SQLQuery)baseQuery.limit((long)currentLimit)).offset((long)(start + resultCount));
                            queryStr = query.getSQL().getSQL();
                            LOG.debug("Executing query: '" + queryStr + "'");
                            resultSet = query.getResults();
                            lastResult = this.getEntryDataList(tableMapping, resultSet);
                            lastCountRows = lastResult.size();
                            if (batchOperation != null) {
                                collectSearchResult = batchOperation.collectSearchResult(lastCountRows);
                            }
                            if (collectSearchResult) {
                                searchResultList.addAll(lastResult);
                            }
                            if (batchOperation == null) continue;
                            List<O> entries = batchOperationWraper.createEntities(lastResult);
                            batchOperation.performAction(entries);
                        } while ((count <= 0 || (resultCount += lastCountRows) < count) && lastCountRows >= currentLimit && lastCountRows > 0);
                        if (resultSet == null) break block45;
                    }
                    catch (QueryException ex) {
                        try {
                            ex.printStackTrace();
                            throw new SearchException(String.format("Failed to build search entries query. Key: '%s', expression: '%s'", key, expression.expression()), (Throwable)ex);
                            catch (SQLException | EntryConvertationException ex2) {
                                throw new SearchException(String.format("Failed to execute query '%s'  with key: '%s'", queryStr, key), ex2);
                            }
                        }
                        catch (Throwable throwable) {
                            if (resultSet == null) throw throwable;
                            try {
                                resultSet.close();
                                throw throwable;
                            }
                            catch (SQLException ex3) {
                                throw new SearchException(String.format("Failed to close query after paged result collection. Query '%s'  with key: '%s'", queryStr, key), (Throwable)ex3);
                            }
                        }
                    }
                    try {
                        resultSet.close();
                    }
                    catch (SQLException ex) {
                        throw new SearchException(String.format("Failed to close query after paged result collection. Query '%s'  with key: '%s'", queryStr, key), (Throwable)ex);
                    }
                } else {
                    try {
                        SQLQuery query = baseQuery;
                        if (count > 0) {
                            query = (SQLQuery)query.limit((long)count);
                        }
                        if (start > 0) {
                            query = (SQLQuery)query.offset((long)start);
                        }
                        queryStr = query.getSQL().getSQL();
                        LOG.debug("Execution query: '" + queryStr + "'");
                        try (ResultSet resultSet = query.getResults();){
                            lastResult = this.getEntryDataList(tableMapping, resultSet);
                            searchResultList.addAll(lastResult);
                        }
                    }
                    catch (QueryException ex) {
                        String sqlExpression = queryStr;
                        if (StringHelper.isNotEmpty(sqlExpression)) {
                            sqlExpression = expression.expression().toString();
                        }
                        throw new SearchException(String.format("Failed to build search entries query. Key: '%s', expression: '%s'", key, sqlExpression), (Throwable)ex);
                    }
                    catch (SQLException | EntryConvertationException ex) {
                        throw new SearchException("Failed to search entries. Query: '" + queryStr + "'", ex);
                    }
                }
            }
        }
        PagedResult result = new PagedResult();
        result.setEntries(searchResultList);
        result.setEntriesCount(searchResultList.size());
        result.setStart(start);
        if (SearchReturnDataType.COUNT != returnDataType) {
            if (SearchReturnDataType.SEARCH_COUNT != returnDataType) return result;
        }
        if (expression == null) {
            sqlCountSelectQuery = (SQLQuery)this.sqlQueryFactory.select((Expression)Expressions.as((Expression)ExpressionUtils.count((Expression)Wildcard.all), (String)"TOTAL")).from(tableRelationalPath);
        } else {
            Predicate whereExp = (Predicate)expression.expression();
            sqlCountSelectQuery = (SQLQuery)((SQLQuery)this.sqlQueryFactory.select((Expression)Expressions.as((Expression)ExpressionUtils.count((Expression)Wildcard.all), (String)"TOTAL")).from(tableRelationalPath)).where(whereExp);
        }
        try {
            queryStr = sqlCountSelectQuery.getSQL().getSQL();
            LOG.debug("Calculating count. Execution query: '" + queryStr + "'");
            try (ResultSet countResult = sqlCountSelectQuery.getResults();){
                if (!countResult.next()) {
                    throw new SearchException("Failed to calculate count entries. Query: '" + queryStr + "'");
                }
                result.setTotalEntriesCount(countResult.getInt("TOTAL"));
                return result;
            }
        }
        catch (QueryException ex) {
            throw new SearchException(String.format("Failed to build count search entries query. Key: '%s', expression: '%s'", key, expression.expression()), (Throwable)ex);
        }
        catch (SQLException ex) {
            throw new SearchException("Failed to calculate count entries. Query: '" + queryStr + "'", (Throwable)ex);
        }
    }

    @Override
    public String[] createStoragePassword(String[] passwords) {
        if (ArrayHelper.isEmpty((Object[])passwords)) {
            return passwords;
        }
        String[] results = new String[passwords.length];
        for (int i = 0; i < passwords.length; ++i) {
            results[i] = this.persistenceExtension == null ? PasswordEncryptionHelper.createStoragePassword((String)passwords[i], (PasswordEncryptionMethod)this.connectionProvider.getPasswordEncryptionMethod()) : this.persistenceExtension.createHashedPassword(passwords[i]);
        }
        return results;
    }

    private List<AttributeData> getAttributeDataList(TableMapping tableMapping, ResultSet resultSet, boolean skipDn) throws EntryConvertationException {
        try {
            if (resultSet == null) {
                return null;
            }
            if (!resultSet.next()) {
                return null;
            }
            ArrayList<AttributeData> result = new ArrayList<AttributeData>();
            int columnsCount = resultSet.getMetaData().getColumnCount();
            for (int i = 1; i <= columnsCount; ++i) {
                Object value;
                Object[] attributeValueObjects;
                ResultSetMetaData metaData = resultSet.getMetaData();
                String shortAttributeName = metaData.getColumnName(i);
                String columnTypeName = metaData.getColumnTypeName(i).toLowerCase();
                boolean isNullable = metaData.isNullable(i) == 1;
                Object attributeObject = resultSet.getObject(shortAttributeName);
                if ("doc_id".equalsIgnoreCase(shortAttributeName) || "id".equalsIgnoreCase(shortAttributeName) || skipDn && "dn".equalsIgnoreCase(shortAttributeName)) continue;
                String attributeName = this.fromInternalAttribute(shortAttributeName);
                Boolean multiValued = Boolean.FALSE;
                if (attributeObject == null) {
                    attributeValueObjects = NO_OBJECTS;
                    if (isNullable) {
                        continue;
                    }
                } else if (this.isJsonColumn(tableMapping.getTableName(), columnTypeName)) {
                    attributeValueObjects = this.convertDbJsonToValue(attributeObject.toString());
                    multiValued = Boolean.TRUE;
                } else if (attributeObject instanceof Integer) {
                    int columnType = resultSet.getMetaData().getColumnType(i);
                    if (columnType == 5) {
                        if (attributeObject.equals(0)) {
                            attributeObject = Boolean.FALSE;
                        } else if (attributeObject.equals(1)) {
                            attributeObject = Boolean.TRUE;
                        }
                    }
                    attributeValueObjects = new Object[]{attributeObject};
                } else if (attributeObject instanceof Boolean || attributeObject instanceof Long) {
                    attributeValueObjects = new Object[]{attributeObject};
                } else if (attributeObject instanceof String) {
                    value = attributeObject.toString();
                    try {
                        SimpleDateFormat jsonDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                        value = jsonDateFormat.parse(attributeObject.toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    attributeValueObjects = new Object[]{value};
                } else if (attributeObject instanceof Timestamp) {
                    attributeValueObjects = new Object[]{new Date(((Timestamp)attributeObject).getTime())};
                } else {
                    value = attributeObject.toString();
                    attributeValueObjects = new Object[]{value};
                }
                this.unescapeValues(attributeValueObjects);
                AttributeData tmpAttribute = new AttributeData(attributeName, attributeValueObjects, multiValued);
                if (multiValued != null) {
                    tmpAttribute.setMultiValued(multiValued);
                }
                result.add(tmpAttribute);
            }
            return result;
        }
        catch (SQLException ex) {
            throw new EntryConvertationException("Failed to convert entry!", (Throwable)ex);
        }
    }

    private List<EntryData> getEntryDataList(TableMapping tableMapping, ResultSet resultSet) throws EntryConvertationException, SQLException {
        LinkedList<EntryData> entryDataList = new LinkedList<EntryData>();
        List<AttributeData> attributeDataList = null;
        while (!resultSet.isLast() && (attributeDataList = this.getAttributeDataList(tableMapping, resultSet, false)) != null) {
            EntryData entryData = new EntryData(attributeDataList);
            entryDataList.add(entryData);
        }
        return entryDataList;
    }

    @Override
    public boolean isBinaryAttribute(String attribute) {
        return this.connectionProvider.isBinaryAttribute(attribute);
    }

    @Override
    public boolean isCertificateAttribute(String attribute) {
        return this.connectionProvider.isCertificateAttribute(attribute);
    }

    public boolean isDisableAttributeMapping() {
        return this.disableAttributeMapping;
    }

    @Override
    public boolean destroy() {
        boolean result = true;
        if (this.connectionProvider != null) {
            try {
                this.connectionProvider.destroy();
            }
            catch (Exception ex) {
                LOG.error("Failed to destroy provider correctly");
                result = false;
            }
        }
        return result;
    }

    public boolean isConnected() {
        return this.connectionProvider.isConnected();
    }

    @Override
    public Connection getConnection() {
        return this.connectionProvider.getConnection();
    }

    @Override
    public DatabaseMetaData getMetadata() {
        return this.connectionProvider.getDatabaseMetaData();
    }

    public void setPersistenceExtension(PersistenceExtension persistenceExtension) {
        this.persistenceExtension = persistenceExtension;
    }

    public boolean isSupportObjectClass(String objectClass) {
        return true;
    }

    private Expression<?> buildSelectAttributes(String ... attributes) {
        if (ArrayHelper.isEmpty((Object[])attributes)) {
            return Expressions.list((Expression[])new Expression[]{Wildcard.all, Expressions.path(Object.class, this.docAlias, (String)"doc_id")});
        }
        if (attributes.length == 1 && StringHelper.isEmpty((String)attributes[0])) {
            return Expressions.list((SimpleExpression[])new SimpleExpression[]{Expressions.path(Object.class, this.docAlias, (String)"dn"), Expressions.path(Object.class, this.docAlias, (String)"doc_id")});
        }
        ArrayList<SimplePath> expresisons = new ArrayList<SimplePath>(attributes.length + 2);
        boolean hasDn = false;
        for (String attribute : attributes) {
            expresisons.add(Expressions.path(Object.class, this.docAlias, (String)attribute));
            hasDn |= StringHelper.equals((String)attribute, (String)"dn");
        }
        if (!hasDn) {
            expresisons.add(Expressions.path(Object.class, this.docAlias, (String)"dn"));
        }
        expresisons.add(Expressions.path(Object.class, this.docAlias, (String)"doc_id"));
        return Expressions.list((Expression[])expresisons.toArray(new Expression[0]));
    }

    private RelationalPathBase<Object> buildTableRelationalPath(TableMapping tableMapping) {
        RelationalPathBase tableRelationalPath = new RelationalPathBase(Object.class, "doc", this.schemaName, tableMapping.getTableName());
        return tableRelationalPath;
    }

    @Override
    public String escapeValue(String value) {
        return value;
    }

    @Override
    public void escapeValues(Object[] realValues) {
    }

    @Override
    public String unescapeValue(String value) {
        return value;
    }

    @Override
    public void unescapeValues(Object[] realValues) {
    }

    @Override
    public String toInternalAttribute(String attributeName) {
        return attributeName;
    }

    @Override
    public String[] toInternalAttributes(String[] attributeNames) {
        return attributeNames;
    }

    @Override
    public String fromInternalAttribute(String internalAttributeName) {
        return internalAttributeName;
    }

    @Override
    public String[] fromInternalAttributes(String[] internalAttributeNames) {
        return internalAttributeNames;
    }

    private String convertValueToDbJson(Object propertyValue) {
        try {
            if (propertyValue == null) {
                JsonAttributeValue jsonAttributeValue = new JsonAttributeValue();
            }
            JsonAttributeValue attributeValue = propertyValue instanceof List ? new JsonAttributeValue(((List)propertyValue).toArray()) : (propertyValue.getClass().isArray() ? new JsonAttributeValue((Object[])propertyValue) : new JsonAttributeValue(new Object[]{propertyValue}));
            String value = JSON_OBJECT_MAPPER.writeValueAsString((Object)attributeValue);
            return value;
        }
        catch (Exception ex) {
            LOG.error("Failed to convert '{}' to json value:", propertyValue, (Object)ex);
            throw new MappingException(String.format("Failed to convert '%s' to json value", propertyValue));
        }
    }

    private Object[] convertDbJsonToValue(String jsonValue) {
        try {
            JsonAttributeValue attributeValue = (JsonAttributeValue)JSON_OBJECT_MAPPER.readValue(jsonValue, JsonAttributeValue.class);
            Object[] values = null;
            if (attributeValue != null) {
                values = attributeValue.getValues();
            }
            return values;
        }
        catch (Exception ex) {
            LOG.error("Failed to convert json value '{}' to array:", (Object)jsonValue, (Object)ex);
            throw new MappingException(String.format("Failed to convert json value '%s' to array", jsonValue));
        }
    }

    private boolean isJsonColumn(String tableName, String columnTypeName) {
        if (columnTypeName == null) {
            return false;
        }
        return "json".equals(columnTypeName);
    }
}

