/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.persist.sql.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.PredicateOperation;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.BooleanOperation;
import com.querydsl.core.types.dsl.Expressions;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.gluu.orm.util.ArrayHelper;
import org.gluu.orm.util.StringHelper;
import org.gluu.persist.annotation.AttributeEnum;
import org.gluu.persist.exception.operation.SearchException;
import org.gluu.persist.ldap.impl.LdapFilterConverter;
import org.gluu.persist.reflect.property.PropertyAnnotation;
import org.gluu.persist.reflect.util.ReflectHelper;
import org.gluu.persist.sql.impl.SqlOps;
import org.gluu.persist.sql.model.ConvertedExpression;
import org.gluu.persist.sql.operation.SqlOperationService;
import org.gluu.search.filter.Filter;
import org.gluu.search.filter.FilterType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlFilterConverter {
    private static final Logger LOG = LoggerFactory.getLogger(SqlFilterConverter.class);
    private static final String SQL_DATA_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final LdapFilterConverter ldapFilterConverter = new LdapFilterConverter();
    private static final ObjectMapper JSON_OBJECT_MAPPER = new ObjectMapper();
    private SqlOperationService operationService;
    private Path<String> stringDocAlias = ExpressionUtils.path(String.class, (String)"doc");
    private Path<Boolean> booleanDocAlias = ExpressionUtils.path(Boolean.class, (String)"doc");
    private Path<Integer> integerDocAlias = ExpressionUtils.path(Integer.class, (String)"doc");
    private Path<Long> longDocAlias = ExpressionUtils.path(Long.class, (String)"doc");
    private Path<Object> objectDocAlias = ExpressionUtils.path(Object.class, (String)"doc");

    public SqlFilterConverter(SqlOperationService operationService) {
        this.operationService = operationService;
    }

    public ConvertedExpression convertToSqlFilter(Filter genericFilter, Map<String, PropertyAnnotation> propertiesAnnotationsMap) throws SearchException {
        return this.convertToSqlFilter(genericFilter, propertiesAnnotationsMap, false);
    }

    public ConvertedExpression convertToSqlFilter(Filter genericFilter, Map<String, PropertyAnnotation> propertiesAnnotationsMap, boolean skipAlias) throws SearchException {
        return this.convertToSqlFilter(genericFilter, propertiesAnnotationsMap, null, skipAlias);
    }

    public ConvertedExpression convertToSqlFilter(Filter genericFilter, Map<String, PropertyAnnotation> propertiesAnnotationsMap, Function<? super Filter, Boolean> processor) throws SearchException {
        return this.convertToSqlFilter(genericFilter, propertiesAnnotationsMap, processor, false);
    }

    public ConvertedExpression convertToSqlFilter(Filter genericFilter, Map<String, PropertyAnnotation> propertiesAnnotationsMap, Function<? super Filter, Boolean> processor, boolean skipAlias) throws SearchException {
        HashMap jsonAttributes = new HashMap();
        ConvertedExpression convertedExpression = this.convertToSqlFilterImpl(genericFilter, propertiesAnnotationsMap, jsonAttributes, processor, skipAlias);
        return convertedExpression;
    }

    private ConvertedExpression convertToSqlFilterImpl(Filter genericFilter, Map<String, PropertyAnnotation> propertiesAnnotationsMap, Map<String, Class<?>> jsonAttributes, Function<? super Filter, Boolean> processor, boolean skipAlias) throws SearchException {
        PredicateOperation operation;
        BooleanExpression predicate;
        ArrayList<BooleanExpression> expressions;
        Expression expression;
        Expression expression2;
        if (genericFilter == null) {
            return null;
        }
        Filter currentGenericFilter = genericFilter;
        FilterType type = currentGenericFilter.getType();
        if (FilterType.RAW == type) {
            LOG.warn("RAW Ldap filter to SQL convertion will be removed in new version!!!");
            currentGenericFilter = ldapFilterConverter.convertRawLdapFilterToFilter(currentGenericFilter.getFilterString());
            type = currentGenericFilter.getType();
        }
        if (processor != null) {
            processor.apply((Filter)currentGenericFilter);
        }
        if (FilterType.NOT == type || FilterType.AND == type || FilterType.OR == type) {
            Filter[] genericFilters = currentGenericFilter.getFilters();
            Predicate[] expFilters = new Predicate[genericFilters.length];
            if (genericFilters != null) {
                boolean canJoinOrFilters = FilterType.OR == type;
                ArrayList<Filter> joinOrFilters = new ArrayList<Filter>();
                String joinOrAttributeName = null;
                for (int i = 0; i < genericFilters.length; ++i) {
                    Filter tmpFilter = genericFilters[i];
                    expFilters[i] = (Predicate)this.convertToSqlFilterImpl(tmpFilter, propertiesAnnotationsMap, jsonAttributes, processor, skipAlias).expression();
                    if (!canJoinOrFilters) continue;
                    if (tmpFilter.getMultiValued() != null) {
                        canJoinOrFilters = false;
                        continue;
                    }
                    if (FilterType.EQUALITY != tmpFilter.getType() || tmpFilter.getFilters() != null) {
                        canJoinOrFilters = false;
                        continue;
                    }
                    Boolean isMultiValuedDetected = this.determineMultiValuedByType(tmpFilter.getAttributeName(), propertiesAnnotationsMap);
                    if (!Boolean.FALSE.equals(isMultiValuedDetected) && !Boolean.FALSE.equals(currentGenericFilter.getMultiValued())) {
                        canJoinOrFilters = false;
                        continue;
                    }
                    if (joinOrAttributeName == null) {
                        joinOrAttributeName = tmpFilter.getAttributeName();
                        joinOrFilters.add(tmpFilter);
                        continue;
                    }
                    if (!joinOrAttributeName.equals(tmpFilter.getAttributeName())) {
                        canJoinOrFilters = false;
                        continue;
                    }
                    joinOrFilters.add(tmpFilter);
                }
                if (FilterType.NOT == type) {
                    return ConvertedExpression.build((Expression)ExpressionUtils.predicate((Operator)Ops.NOT, (Expression[])new Expression[]{expFilters[0]}), jsonAttributes);
                }
                if (FilterType.AND == type) {
                    return ConvertedExpression.build((Expression)ExpressionUtils.allOf((Predicate[])expFilters), jsonAttributes);
                }
                if (FilterType.OR == type) {
                    if (canJoinOrFilters) {
                        ArrayList<Object> rightObjs = new ArrayList<Object>(joinOrFilters.size());
                        Filter lastEqFilter = null;
                        Iterator iterator = joinOrFilters.iterator();
                        while (iterator.hasNext()) {
                            Filter eqFilter;
                            lastEqFilter = eqFilter = (Filter)iterator.next();
                            Object assertionValue = eqFilter.getAssertionValue();
                            if (assertionValue instanceof AttributeEnum) {
                                assertionValue = ((AttributeEnum)assertionValue).getValue();
                            }
                            rightObjs.add(assertionValue);
                        }
                        return ConvertedExpression.build((Expression)ExpressionUtils.in((Expression)this.buildTypedPath(lastEqFilter, propertiesAnnotationsMap, jsonAttributes, processor, skipAlias), rightObjs), jsonAttributes);
                    }
                    return ConvertedExpression.build((Expression)ExpressionUtils.anyOf((Predicate[])expFilters), jsonAttributes);
                }
            }
        }
        if (FilterType.EQUALITY == type) {
            if (this.isMultiValue(currentGenericFilter, propertiesAnnotationsMap).booleanValue()) {
                expression2 = this.buildTypedPath(currentGenericFilter, propertiesAnnotationsMap, jsonAttributes, processor, skipAlias);
                PredicateOperation operation2 = ExpressionUtils.predicate((Operator)SqlOps.JSON_CONTAINS, (Expression[])new Expression[]{expression2, this.buildTypedExpression(currentGenericFilter, true), Expressions.constant((Object)"$.v")});
                return ConvertedExpression.build((Expression)operation2, jsonAttributes);
            }
            Filter usedFilter = currentGenericFilter;
            expression = this.buildTypedPath(currentGenericFilter, propertiesAnnotationsMap, jsonAttributes, processor, skipAlias);
            return ConvertedExpression.build((Expression)ExpressionUtils.eq((Expression)expression, (Expression)this.buildTypedExpression(usedFilter)), jsonAttributes);
        }
        if (FilterType.LESS_OR_EQUAL == type) {
            if (this.isMultiValue(currentGenericFilter, propertiesAnnotationsMap).booleanValue()) {
                if (currentGenericFilter.getMultiValuedCount() > 1) {
                    expressions = new ArrayList<BooleanExpression>(currentGenericFilter.getMultiValuedCount());
                    for (int i = 0; i < currentGenericFilter.getMultiValuedCount(); ++i) {
                        PredicateOperation operation3 = ExpressionUtils.predicate((Operator)SqlOps.JSON_EXTRACT, (Expression[])new Expression[]{this.buildTypedPath(currentGenericFilter, propertiesAnnotationsMap, jsonAttributes, processor, skipAlias), Expressions.constant((Object)("$.v[" + i + "]"))});
                        predicate = Expressions.asComparable((Expression)operation3).loe(this.buildTypedExpression(currentGenericFilter));
                        expressions.add(predicate);
                    }
                    Predicate expression3 = ExpressionUtils.anyOf(expressions);
                    return ConvertedExpression.build((Expression)expression3, jsonAttributes);
                }
                operation = ExpressionUtils.predicate((Operator)SqlOps.JSON_EXTRACT, (Expression[])new Expression[]{this.buildTypedPath(currentGenericFilter, propertiesAnnotationsMap, jsonAttributes, processor, skipAlias), Expressions.constant((Object)"$.v[0]")});
                expression = Expressions.asComparable((Expression)operation).loe(this.buildTypedExpression(currentGenericFilter));
                return ConvertedExpression.build(expression, jsonAttributes);
            }
            return ConvertedExpression.build((Expression)Expressions.asComparable((Expression)this.buildTypedPath(currentGenericFilter, propertiesAnnotationsMap, jsonAttributes, processor, skipAlias)).loe(this.buildTypedExpression(currentGenericFilter)), jsonAttributes);
        }
        if (FilterType.GREATER_OR_EQUAL == type) {
            if (this.isMultiValue(currentGenericFilter, propertiesAnnotationsMap).booleanValue()) {
                if (currentGenericFilter.getMultiValuedCount() > 1) {
                    expressions = new ArrayList(currentGenericFilter.getMultiValuedCount());
                    for (int i = 0; i < currentGenericFilter.getMultiValuedCount(); ++i) {
                        PredicateOperation operation4 = ExpressionUtils.predicate((Operator)SqlOps.JSON_EXTRACT, (Expression[])new Expression[]{this.buildTypedPath(currentGenericFilter, propertiesAnnotationsMap, jsonAttributes, processor, skipAlias), Expressions.constant((Object)("$.v[" + i + "]"))});
                        predicate = Expressions.asComparable((Expression)operation4).goe(this.buildTypedExpression(currentGenericFilter));
                        expressions.add(predicate);
                    }
                    Predicate expression4 = ExpressionUtils.anyOf(expressions);
                    return ConvertedExpression.build((Expression)expression4, jsonAttributes);
                }
                operation = ExpressionUtils.predicate((Operator)SqlOps.JSON_EXTRACT, (Expression[])new Expression[]{this.buildTypedPath(currentGenericFilter, propertiesAnnotationsMap, jsonAttributes, processor, skipAlias), Expressions.constant((Object)"$.v[0]")});
                expression = Expressions.asComparable((Expression)operation).goe(this.buildTypedExpression(currentGenericFilter));
                return ConvertedExpression.build(expression, jsonAttributes);
            }
            return ConvertedExpression.build((Expression)Expressions.asComparable((Expression)this.buildTypedPath(currentGenericFilter, propertiesAnnotationsMap, jsonAttributes, processor, skipAlias)).goe(this.buildTypedExpression(currentGenericFilter)), jsonAttributes);
        }
        if (FilterType.PRESENCE == type) {
            if (this.isMultiValue(currentGenericFilter, propertiesAnnotationsMap).booleanValue()) {
                if (currentGenericFilter.getMultiValuedCount() > 1) {
                    ArrayList<BooleanExpression> expressions2 = new ArrayList<BooleanExpression>(currentGenericFilter.getMultiValuedCount());
                    for (int i = 0; i < currentGenericFilter.getMultiValuedCount(); ++i) {
                        predicate = ExpressionUtils.isNotNull((Expression)ExpressionUtils.predicate((Operator)SqlOps.JSON_EXTRACT, (Expression[])new Expression[]{this.buildTypedPath(currentGenericFilter, propertiesAnnotationsMap, jsonAttributes, processor, skipAlias), Expressions.constant((Object)("$.v[" + i + "]"))}));
                        expressions2.add(predicate);
                    }
                    Predicate predicate2 = ExpressionUtils.anyOf(expressions2);
                    return ConvertedExpression.build((Expression)predicate2, jsonAttributes);
                }
                expression2 = ExpressionUtils.predicate((Operator)SqlOps.JSON_EXTRACT, (Expression[])new Expression[]{this.buildTypedPath(currentGenericFilter, propertiesAnnotationsMap, jsonAttributes, processor, skipAlias), Expressions.constant((Object)"$.v[0]")});
            } else {
                expression2 = this.buildTypedPath(currentGenericFilter, propertiesAnnotationsMap, jsonAttributes, processor, skipAlias);
            }
            return ConvertedExpression.build((Expression)ExpressionUtils.isNotNull((Expression)expression2), jsonAttributes);
        }
        if (FilterType.APPROXIMATE_MATCH == type) {
            throw new SearchException("Convertion from APPROXIMATE_MATCH LDAP filter to SQL filter is not implemented");
        }
        if (FilterType.SUBSTRING == type) {
            Expression expression5;
            StringBuilder like = new StringBuilder();
            if (currentGenericFilter.getSubInitial() != null) {
                like.append(currentGenericFilter.getSubInitial());
            }
            like.append("%");
            String[] subAny = currentGenericFilter.getSubAny();
            if (subAny != null && subAny.length > 0) {
                for (String any : subAny) {
                    like.append(any);
                    like.append("%");
                }
            }
            if (currentGenericFilter.getSubFinal() != null) {
                like.append(currentGenericFilter.getSubFinal());
            }
            if (this.isMultiValue(currentGenericFilter, propertiesAnnotationsMap).booleanValue()) {
                if (currentGenericFilter.getMultiValuedCount() > 1) {
                    ArrayList<BooleanOperation> expressions3 = new ArrayList<BooleanOperation>(currentGenericFilter.getMultiValuedCount());
                    for (int i = 0; i < currentGenericFilter.getMultiValuedCount(); ++i) {
                        PredicateOperation operation5 = ExpressionUtils.predicate((Operator)SqlOps.JSON_EXTRACT, (Expression[])new Expression[]{this.buildTypedPath(currentGenericFilter, propertiesAnnotationsMap, jsonAttributes, processor, skipAlias), Expressions.constant((Object)("$.v[" + i + "]"))});
                        BooleanOperation predicate3 = Expressions.booleanOperation((Operator)Ops.LIKE, (Expression[])new Expression[]{operation5, Expressions.constant((Object)like.toString())});
                        expressions3.add(predicate3);
                    }
                    Predicate predicate4 = ExpressionUtils.anyOf(expressions3);
                    return ConvertedExpression.build((Expression)predicate4, jsonAttributes);
                }
                expression5 = ExpressionUtils.predicate((Operator)SqlOps.JSON_EXTRACT, (Expression[])new Expression[]{this.buildTypedPath(currentGenericFilter, propertiesAnnotationsMap, jsonAttributes, processor, skipAlias), Expressions.constant((Object)"$.v[0]")});
            } else {
                expression5 = this.buildTypedPath(currentGenericFilter, propertiesAnnotationsMap, jsonAttributes, processor, skipAlias);
            }
            return ConvertedExpression.build((Expression)Expressions.booleanOperation((Operator)Ops.LIKE, (Expression[])new Expression[]{expression5, Expressions.constant((Object)like.toString())}), jsonAttributes);
        }
        if (FilterType.LOWERCASE == type) {
            return ConvertedExpression.build(ExpressionUtils.toLower((Expression)this.buildTypedPath(currentGenericFilter, propertiesAnnotationsMap, jsonAttributes, processor, skipAlias)), jsonAttributes);
        }
        throw new SearchException(String.format("Unknown filter type '%s'", type));
    }

    protected Boolean isMultiValue(Filter currentGenericFilter, Map<String, PropertyAnnotation> propertiesAnnotationsMap) {
        Boolean isMultiValuedDetected = this.determineMultiValuedByType(currentGenericFilter.getAttributeName(), propertiesAnnotationsMap);
        if (Boolean.TRUE.equals(currentGenericFilter.getMultiValued()) || Boolean.TRUE.equals(isMultiValuedDetected)) {
            return true;
        }
        return false;
    }

    private String toInternalAttribute(Filter filter) {
        String attributeName = filter.getAttributeName();
        if (StringHelper.isEmpty((String)attributeName)) {
            Filter subFilter;
            Filter[] filterArray = filter.getFilters();
            int n = filterArray.length;
            for (int i = 0; i < n && !StringHelper.isNotEmpty((String)(attributeName = (subFilter = filterArray[i]).getAttributeName())); ++i) {
            }
        }
        return this.toInternalAttribute(attributeName);
    }

    private String toInternalAttribute(String attributeName) {
        if (this.operationService == null) {
            return attributeName;
        }
        return this.operationService.toInternalAttribute(attributeName);
    }

    private Expression buildTypedExpression(Filter filter) throws SearchException {
        return this.buildTypedExpression(filter, false);
    }

    private Expression buildTypedExpression(Filter filter, boolean isArray) throws SearchException {
        Object assertionValue = filter.getAssertionValue();
        if (assertionValue instanceof AttributeEnum) {
            assertionValue = ((AttributeEnum)assertionValue).getValue();
        } else if (assertionValue instanceof Date) {
            SimpleDateFormat jsonDateFormat = new SimpleDateFormat(SQL_DATA_FORMAT);
            assertionValue = jsonDateFormat.format(filter.getAssertionValue());
        }
        if (isArray && assertionValue instanceof String) {
            assertionValue = "[\"" + assertionValue + "\"]";
        } else if (Boolean.TRUE.equals(filter.getMultiValued())) {
            assertionValue = this.convertValueToJson(Arrays.asList(assertionValue));
        }
        return Expressions.constant((Object)assertionValue);
    }

    private Expression buildTypedPath(Filter genericFilter, Map<String, PropertyAnnotation> propertiesAnnotationsMap, Map<String, Class<?>> jsonAttributes, Function<? super Filter, Boolean> processor, boolean skipAlias) throws SearchException {
        boolean hasSubFilters = ArrayHelper.isNotEmpty((Object[])genericFilter.getFilters());
        if (hasSubFilters) {
            return this.convertToSqlFilterImpl(genericFilter.getFilters()[0], propertiesAnnotationsMap, jsonAttributes, processor, skipAlias).expression();
        }
        String internalAttribute = this.toInternalAttribute(genericFilter);
        return this.buildTypedPath(genericFilter, internalAttribute, skipAlias);
    }

    private Expression buildTypedPath(Filter filter, String attributeName, boolean skipAlias) {
        if (filter.getAssertionValue() instanceof String) {
            if (skipAlias) {
                return Expressions.stringPath((String)attributeName);
            }
            return Expressions.stringPath(this.stringDocAlias, (String)attributeName);
        }
        if (filter.getAssertionValue() instanceof Boolean) {
            if (skipAlias) {
                return Expressions.booleanPath((String)attributeName);
            }
            return Expressions.booleanPath(this.booleanDocAlias, (String)attributeName);
        }
        if (filter.getAssertionValue() instanceof Integer) {
            if (skipAlias) {
                return Expressions.stringPath((String)attributeName);
            }
            return Expressions.stringPath(this.integerDocAlias, (String)attributeName);
        }
        if (filter.getAssertionValue() instanceof Long) {
            if (skipAlias) {
                return Expressions.stringPath((String)attributeName);
            }
            return Expressions.stringPath(this.longDocAlias, (String)attributeName);
        }
        if (skipAlias) {
            return Expressions.stringPath((String)attributeName);
        }
        return Expressions.stringPath(this.objectDocAlias, (String)attributeName);
    }

    private Boolean determineMultiValuedByType(String attributeName, Map<String, PropertyAnnotation> propertiesAnnotationsMap) {
        if (attributeName == null || propertiesAnnotationsMap == null) {
            return null;
        }
        if (StringHelper.equalsIgnoreCase((String)attributeName, (String)"objectClass")) {
            return false;
        }
        PropertyAnnotation propertyAnnotation = propertiesAnnotationsMap.get(attributeName);
        if (propertyAnnotation == null || propertyAnnotation.getParameterType() == null) {
            return null;
        }
        Class parameterType = propertyAnnotation.getParameterType();
        boolean isMultiValued = parameterType.equals(Object[].class) || parameterType.equals(String[].class) || ReflectHelper.assignableFrom((Class)parameterType, List.class) || ReflectHelper.assignableFrom((Class)parameterType, AttributeEnum[].class);
        return isMultiValued;
    }

    protected String convertValueToJson(Object propertyValue) throws SearchException {
        try {
            String value = JSON_OBJECT_MAPPER.writeValueAsString(propertyValue);
            return value;
        }
        catch (Exception ex) {
            LOG.error("Failed to convert '{}' to json value:", propertyValue, (Object)ex);
            throw new SearchException(String.format("Failed to convert '%s' to json value", propertyValue));
        }
    }
}

