/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.subdoc;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.kv.subdoc.multi.Mutation;
import com.couchbase.client.java.PersistTo;
import com.couchbase.client.java.ReplicateTo;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.subdoc.AsyncMutateInBuilder;
import com.couchbase.client.java.subdoc.DocumentFragment;
import com.couchbase.client.java.subdoc.SubdocOptionsBuilder;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

@InterfaceStability.Committed
@InterfaceAudience.Public
public class MutateInBuilder {
    private final long defaultTimeout;
    private final TimeUnit defaultTimeUnit;
    private final AsyncMutateInBuilder asyncBuilder;

    @InterfaceAudience.Private
    public MutateInBuilder(AsyncMutateInBuilder asyncBuilder, long defaultTimeout, TimeUnit defaultTimeUnit) {
        this.asyncBuilder = asyncBuilder;
        this.defaultTimeout = defaultTimeout;
        this.defaultTimeUnit = defaultTimeUnit;
    }

    public DocumentFragment<Mutation> execute() {
        return this.execute(this.defaultTimeout, this.defaultTimeUnit);
    }

    public DocumentFragment<Mutation> execute(PersistTo persistTo, ReplicateTo replicateTo) {
        return this.execute(persistTo, replicateTo, this.defaultTimeout, this.defaultTimeUnit);
    }

    public DocumentFragment<Mutation> execute(PersistTo persistTo) {
        return this.execute(persistTo, this.defaultTimeout, this.defaultTimeUnit);
    }

    public DocumentFragment<Mutation> execute(ReplicateTo replicateTo) {
        return this.execute(replicateTo, this.defaultTimeout, this.defaultTimeUnit);
    }

    public DocumentFragment<Mutation> execute(long timeout, TimeUnit timeUnit) {
        return (DocumentFragment)this.asyncBuilder.execute(timeout, timeUnit).toBlocking().single();
    }

    public DocumentFragment<Mutation> execute(PersistTo persistTo, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return (DocumentFragment)this.asyncBuilder.execute(persistTo, replicateTo, timeout, timeUnit).toBlocking().single();
    }

    public DocumentFragment<Mutation> execute(PersistTo persistTo, long timeout, TimeUnit timeUnit) {
        return (DocumentFragment)this.asyncBuilder.execute(persistTo, timeout, timeUnit).toBlocking().single();
    }

    public DocumentFragment<Mutation> execute(ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return (DocumentFragment)this.asyncBuilder.execute(replicateTo, timeout, timeUnit).toBlocking().single();
    }

    public MutateInBuilder withExpiry(int expiry) {
        this.asyncBuilder.withExpiry(expiry);
        return this;
    }

    public MutateInBuilder withCas(long cas) {
        this.asyncBuilder.withCas(cas);
        return this;
    }

    public MutateInBuilder withDurability(PersistTo persistTo) {
        this.asyncBuilder.withDurability(persistTo);
        return this;
    }

    public MutateInBuilder withDurability(ReplicateTo replicateTo) {
        this.asyncBuilder.withDurability(replicateTo);
        return this;
    }

    public MutateInBuilder withDurability(PersistTo persistTo, ReplicateTo replicateTo) {
        this.asyncBuilder.withDurability(persistTo, replicateTo);
        return this;
    }

    @Deprecated
    public MutateInBuilder createDocument(boolean createDocument) {
        this.asyncBuilder.createDocument(createDocument);
        return this;
    }

    @InterfaceStability.Committed
    public MutateInBuilder upsertDocument(boolean upsertDocument) {
        this.asyncBuilder.upsertDocument(upsertDocument);
        return this;
    }

    @InterfaceStability.Committed
    public MutateInBuilder insertDocument(boolean insertDocument) {
        this.asyncBuilder.insertDocument(insertDocument);
        return this;
    }

    public <T> MutateInBuilder replace(String path, T fragment) {
        this.asyncBuilder.replace(path, fragment);
        return this;
    }

    @Deprecated
    public <T> MutateInBuilder insert(String path, T fragment, boolean createPath) {
        this.asyncBuilder.insert(path, fragment, createPath);
        return this;
    }

    public <T> MutateInBuilder insert(String path, T fragment) {
        this.asyncBuilder.insert(path, fragment);
        return this;
    }

    public <T> MutateInBuilder insert(String path, T fragment, SubdocOptionsBuilder optionsBuilder) {
        this.asyncBuilder.insert(path, fragment, optionsBuilder);
        return this;
    }

    @Deprecated
    public <T> MutateInBuilder upsert(String path, T fragment, boolean createPath) {
        this.asyncBuilder.upsert(path, fragment, new SubdocOptionsBuilder().createPath(createPath));
        return this;
    }

    public <T> MutateInBuilder upsert(String path, T fragment) {
        this.asyncBuilder.upsert(path, fragment);
        return this;
    }

    @InterfaceStability.Committed
    public MutateInBuilder upsert(JsonObject content) {
        this.asyncBuilder.upsert(content);
        return this;
    }

    public <T> MutateInBuilder upsert(String path, T fragment, SubdocOptionsBuilder optionsBuilder) {
        this.asyncBuilder.upsert(path, fragment, optionsBuilder);
        return this;
    }

    public <T> MutateInBuilder remove(String path) {
        this.asyncBuilder.remove(path);
        return this;
    }

    public <T> MutateInBuilder remove(String path, SubdocOptionsBuilder optionsBuilder) {
        if (optionsBuilder.createPath()) {
            throw new IllegalArgumentException("Options createPath are not supported for remove");
        }
        this.asyncBuilder.remove(path, optionsBuilder);
        return this;
    }

    @Deprecated
    public MutateInBuilder counter(String path, long delta, boolean createPath) {
        this.asyncBuilder.counter(path, delta, new SubdocOptionsBuilder().createPath(createPath));
        return this;
    }

    public MutateInBuilder counter(String path, long delta) {
        this.asyncBuilder.counter(path, delta);
        return this;
    }

    public MutateInBuilder counter(String path, long delta, SubdocOptionsBuilder optionsBuilder) {
        this.asyncBuilder.counter(path, delta, optionsBuilder);
        return this;
    }

    @Deprecated
    public <T> MutateInBuilder arrayPrepend(String path, T value, boolean createPath) {
        this.asyncBuilder.arrayPrepend(path, value, new SubdocOptionsBuilder().createPath(createPath));
        return this;
    }

    public <T> MutateInBuilder arrayPrepend(String path, T value) {
        this.asyncBuilder.arrayPrepend(path, value);
        return this;
    }

    public <T> MutateInBuilder arrayPrepend(String path, T value, SubdocOptionsBuilder optionsBuilder) {
        this.asyncBuilder.arrayPrepend(path, value, optionsBuilder);
        return this;
    }

    @Deprecated
    public <T> MutateInBuilder arrayPrependAll(String path, Collection<T> values, boolean createPath) {
        this.asyncBuilder.arrayPrependAll(path, values, new SubdocOptionsBuilder().createPath(createPath));
        return this;
    }

    public <T> MutateInBuilder arrayPrependAll(String path, Collection<T> values, SubdocOptionsBuilder optionsBuilder) {
        this.asyncBuilder.arrayPrependAll(path, values, optionsBuilder);
        return this;
    }

    public <T> MutateInBuilder arrayPrependAll(String path, T ... values) {
        this.asyncBuilder.arrayPrependAll(path, values);
        return this;
    }

    @Deprecated
    public <T> MutateInBuilder arrayAppend(String path, T value, boolean createPath) {
        this.asyncBuilder.arrayAppend(path, value, new SubdocOptionsBuilder().createPath(createPath));
        return this;
    }

    public <T> MutateInBuilder arrayAppend(String path, T value) {
        this.asyncBuilder.arrayAppend(path, value);
        return this;
    }

    public <T> MutateInBuilder arrayAppend(String path, T value, SubdocOptionsBuilder optionsBuilder) {
        this.asyncBuilder.arrayAppend(path, value, optionsBuilder);
        return this;
    }

    @Deprecated
    public <T> MutateInBuilder arrayAppendAll(String path, Collection<T> values, boolean createPath) {
        this.asyncBuilder.arrayAppendAll(path, values, new SubdocOptionsBuilder().createPath(createPath));
        return this;
    }

    public <T> MutateInBuilder arrayAppendAll(String path, Collection<T> values, SubdocOptionsBuilder optionsBuilder) {
        this.asyncBuilder.arrayAppendAll(path, values, optionsBuilder);
        return this;
    }

    public <T> MutateInBuilder arrayAppendAll(String path, T ... values) {
        this.asyncBuilder.arrayAppendAll(path, values);
        return this;
    }

    public <T> MutateInBuilder arrayInsert(String path, T value) {
        this.asyncBuilder.arrayInsert(path, value);
        return this;
    }

    public <T> MutateInBuilder arrayInsert(String path, T value, SubdocOptionsBuilder optionsBuilder) {
        this.asyncBuilder.arrayInsert(path, value, optionsBuilder);
        return this;
    }

    public <T> MutateInBuilder arrayInsertAll(String path, Collection<T> values) {
        this.asyncBuilder.arrayInsertAll(path, values);
        return this;
    }

    public <T> MutateInBuilder arrayInsertAll(String path, Collection<T> values, SubdocOptionsBuilder optionsBuilder) {
        this.asyncBuilder.arrayInsertAll(path, values, optionsBuilder);
        return this;
    }

    public <T> MutateInBuilder arrayInsertAll(String path, T ... values) {
        this.asyncBuilder.arrayInsertAll(path, values);
        return this;
    }

    @Deprecated
    public <T> MutateInBuilder arrayAddUnique(String path, T value, boolean createPath) {
        this.asyncBuilder.arrayAddUnique(path, value, new SubdocOptionsBuilder().createPath(createPath));
        return this;
    }

    public <T> MutateInBuilder arrayAddUnique(String path, T value) {
        this.asyncBuilder.arrayAddUnique(path, value);
        return this;
    }

    public <T> MutateInBuilder arrayAddUnique(String path, T value, SubdocOptionsBuilder optionsBuilder) {
        this.asyncBuilder.arrayAddUnique(path, value, optionsBuilder);
        return this;
    }

    public String toString() {
        return this.asyncBuilder.toString();
    }
}

