/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.search.filter;

import java.util.LinkedList;
import org.gluu.orm.util.StringHelper;
import org.gluu.search.filter.Filter;
import org.gluu.search.filter.FilterType;

public class FilterProcessor {
    public static final Filter OBJECT_CLASS_EQUALITY_FILTER = Filter.createEqualityFilter("objectClass", null);
    public static final Filter OBJECT_CLASS_PRESENCE_FILTER = Filter.createPresenceFilter("objectClass");

    public Filter excludeFilter(Filter genericFilter, Filter ... excludeFilters) {
        if (genericFilter == null) {
            return null;
        }
        FilterType type = genericFilter.getType();
        if (FilterType.RAW == type) {
            return genericFilter;
        }
        Filter[] filters = genericFilter.getFilters();
        if (filters != null) {
            LinkedList<Filter> resultFilters = new LinkedList<Filter>();
            for (Filter filter : filters) {
                Filter resultFilter = this.excludeFilter(filter, excludeFilters);
                if (resultFilter == null) continue;
                resultFilters.add(resultFilter);
            }
            if (resultFilters.size() == 0) {
                return null;
            }
            Filter resultFilter = new Filter(type, resultFilters.toArray(new Filter[0]));
            resultFilter.setAssertionValue(genericFilter.getAssertionValue());
            return resultFilter;
        }
        for (Filter excludeFilter : excludeFilters) {
            boolean valueMatch;
            boolean typeMatch = excludeFilter.getType() == null || excludeFilter.getType() == type;
            boolean nameMatch = StringHelper.isEmpty((String)excludeFilter.getAttributeName()) || StringHelper.equalsIgnoreCase((String)excludeFilter.getAttributeName(), (String)genericFilter.getAttributeName());
            boolean bl = valueMatch = StringHelper.isEmptyString((Object)excludeFilter.getAssertionValue()) || excludeFilter.getAssertionValue().equals(genericFilter.getAssertionValue());
            if (!typeMatch || !nameMatch || !valueMatch) continue;
            return null;
        }
        return genericFilter;
    }
}

