/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.persist.cloud.spanner.model;

import com.google.cloud.spanner.Type;
import java.util.Map;

public class TableMapping {
    private final String baseKeyName;
    private final String tableName;
    private final String objectClass;
    private final Map<String, Type.StructField> columTypes;
    private Map<String, TableMapping> childTableMapping;

    public TableMapping(String baseKeyName, String tableName, String objectClass, Map<String, Type.StructField> columTypes) {
        this.baseKeyName = baseKeyName;
        this.tableName = tableName;
        this.objectClass = objectClass;
        this.columTypes = columTypes;
    }

    public String getBaseKeyName() {
        return this.baseKeyName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getObjectClass() {
        return this.objectClass;
    }

    public Map<String, Type.StructField> getColumTypes() {
        return this.columTypes;
    }

    public Map<String, TableMapping> getChildTableMapping() {
        return this.childTableMapping;
    }

    public void setChildTableMapping(Map<String, TableMapping> childTableMapping) {
        this.childTableMapping = childTableMapping;
    }

    public boolean hasChildTables() {
        return this.childTableMapping != null && this.childTableMapping.size() > 0;
    }

    public boolean hasChildTableForAttribute(String attributeName) {
        if (!this.hasChildTables()) {
            return false;
        }
        return this.childTableMapping.containsKey(attributeName);
    }

    public TableMapping getChildTableMappingForAttribute(String attributeName) {
        if (!this.hasChildTableForAttribute(attributeName)) {
            return null;
        }
        return this.childTableMapping.get(attributeName);
    }
}

