/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.persist.model.base;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class CustomAttribute
implements Serializable,
Comparable<CustomAttribute> {
    private static final long serialVersionUID = 1468450094325306154L;
    private String name;
    private boolean multiValued;
    private List<String> values;

    public CustomAttribute() {
    }

    public CustomAttribute(String name) {
        this.name = name;
    }

    public CustomAttribute(String name, String value) {
        this.name = name;
        this.setValue(value);
    }

    public CustomAttribute(String name, List<String> values) {
        this.name = name;
        this.values = values;
    }

    public String getValue() {
        if (this.values == null) {
            return null;
        }
        if (this.values.size() > 0) {
            return String.valueOf(this.values.get(0));
        }
        return null;
    }

    public void setValue(String value) {
        this.values = new ArrayList<String>();
        this.values.add(value);
        this.multiValued = false;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
        this.multiValued = values != null && values.size() > 1;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }

    public CustomAttribute setMultiValued(boolean multiValued) {
        this.multiValued = multiValued;
        return this;
    }

    public String getDisplayValue() {
        if (this.values == null) {
            return "";
        }
        if (this.values.size() == 1) {
            return this.values.get(0);
        }
        StringBuilder sb = new StringBuilder(this.values.get(0));
        for (int i = 1; i < this.values.size(); ++i) {
            sb.append(", ").append(this.values.get(i));
        }
        return sb.toString();
    }

    public CustomAttribute multiValued() {
        this.multiValued = true;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomAttribute that = (CustomAttribute)o;
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public String toString() {
        return String.format("Attribute [name=%s, multiValued=%s, value=%s]", this.name, this.multiValued, this.values);
    }

    @Override
    public int compareTo(CustomAttribute o) {
        return this.name.compareTo(o.name);
    }
}

