/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.gluu.oxauth.model.common.HasParamName;
import org.gluu.persist.annotation.AttributeEnum;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Util {
    private static final Logger LOG = Logger.getLogger(Util.class);
    public static final String UTF8_STRING_ENCODING = "UTF-8";

    public static ObjectMapper createJsonMapper() {
        JaxbAnnotationIntrospector jaxb = new JaxbAnnotationIntrospector();
        JacksonAnnotationIntrospector jackson = new JacksonAnnotationIntrospector();
        AnnotationIntrospector pair = AnnotationIntrospector.pair((AnnotationIntrospector)jackson, (AnnotationIntrospector)jaxb);
        ObjectMapper mapper = new ObjectMapper();
        mapper.getDeserializationConfig().with(pair);
        mapper.getSerializationConfig().with(pair);
        return mapper;
    }

    public static String asJsonSilently(Object p_object) {
        try {
            return Util.asJson(p_object);
        }
        catch (IOException e) {
            LOG.trace((Object)e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static String asPrettyJson(Object p_object) throws IOException {
        ObjectMapper mapper = Util.createJsonMapper().configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        mapper.setDefaultPropertyInclusion(JsonInclude.Include.NON_EMPTY);
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(p_object);
    }

    public static String asJson(Object p_object) throws IOException {
        ObjectMapper mapper = Util.createJsonMapper().configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        mapper.setDefaultPropertyInclusion(JsonInclude.Include.NON_EMPTY);
        return mapper.writeValueAsString(p_object);
    }

    public static byte[] getBytes(String p_str) throws UnsupportedEncodingException {
        return p_str.getBytes(UTF8_STRING_ENCODING);
    }

    public static List<String> asList(JSONArray p_array) throws JSONException {
        int length;
        ArrayList<String> result = new ArrayList<String>();
        if (p_array != null && (length = p_array.length()) > 0) {
            for (int i = 0; i < length; ++i) {
                result.add(p_array.getString(i));
            }
        }
        return result;
    }

    public static <T extends AttributeEnum> List<T> asEnumList(JSONArray p_array, Class<T> clazz) throws JSONException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        int length;
        ArrayList<AttributeEnum> result = new ArrayList<AttributeEnum>();
        if (p_array != null && (length = p_array.length()) > 0) {
            for (int i = 0; i < length; ++i) {
                Method method = clazz.getMethod("getByValue", String.class);
                result.add((AttributeEnum)method.invoke(null, p_array.getString(i)));
            }
        }
        return result;
    }

    public static void addToListIfHas(List<String> p_list, JSONObject jsonObj, String p_key) throws JSONException {
        if (jsonObj != null && StringUtils.isNotBlank((String)p_key) && jsonObj.has(p_key)) {
            JSONArray array = jsonObj.getJSONArray(p_key);
            if (p_list != null && array != null) {
                p_list.addAll(Util.asList(array));
            }
        }
    }

    public static void addToJSONObjectIfNotNull(JSONObject p_jsonObject, String key, Object value) throws JSONException {
        if (p_jsonObject != null && value != null && StringUtils.isNotBlank((String)key)) {
            p_jsonObject.put(key, value);
        }
    }

    public static void addToJSONObjectIfNotNull(JSONObject p_jsonObject, String key, AttributeEnum value) throws JSONException {
        if (p_jsonObject != null && value != null && StringUtils.isNotBlank((String)key)) {
            p_jsonObject.put(key, (Object)value.getValue());
        }
    }

    public static void addToJSONObjectIfNotNull(JSONObject p_jsonObject, String key, String[] value) throws JSONException {
        if (p_jsonObject != null && value != null && StringUtils.isNotBlank((String)key)) {
            p_jsonObject.put(key, (Object)new JSONArray(Arrays.asList(value)));
        }
    }

    public static String asString(List<? extends HasParamName> p_list) {
        StringBuilder sb = new StringBuilder();
        if (p_list != null && !p_list.isEmpty()) {
            for (HasParamName hasParamName : p_list) {
                sb.append(" ").append(hasParamName.getParamName());
            }
        }
        return sb.toString().trim();
    }

    public static String listAsString(List<String> p_list) {
        StringBuilder param = new StringBuilder();
        if (p_list != null && !p_list.isEmpty()) {
            for (String item : p_list) {
                param.append(" ").append(item);
            }
        }
        return param.toString().trim();
    }

    public static String mapAsString(Map<String, String> p_map) throws JSONException {
        if (p_map == null || p_map.size() == 0) {
            return null;
        }
        JSONArray jsonArray = new JSONArray();
        for (String key : p_map.keySet()) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(key, (Object)p_map.get(key));
            jsonArray.put((Object)jsonObject);
        }
        return jsonArray.toString();
    }

    public static boolean allNotBlank(String ... p_strings) {
        if (p_strings != null && p_strings.length > 0) {
            for (String s : p_strings) {
                if (!StringUtils.isBlank((String)s)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static List<String> splittedStringAsList(String p_string, String p_delimiter) {
        String[] array;
        ArrayList<String> result = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)p_string) && (array = p_string.split(p_delimiter)).length > 0) {
            result.addAll(Arrays.asList(array));
        }
        return result;
    }

    public static List<String> jsonArrayStringAsList(String jsonString) throws JSONException {
        ArrayList<String> result = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)jsonString)) {
            JSONArray jsonArray = new JSONArray(jsonString);
            return Util.asList(jsonArray);
        }
        return result;
    }

    public static JSONArray listToJsonArray(Collection<String> list) {
        if (list == null) {
            return new JSONArray();
        }
        return new JSONArray(list);
    }

    public static Map<String, String> jsonObjectArrayStringAsMap(String jsonString) throws JSONException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (!Util.isNullOrEmpty(jsonString)) {
            JSONArray jsonArray = new JSONArray(jsonString);
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                Iterator keysIter = jsonObject.keys();
                while (keysIter.hasNext()) {
                    String key = (String)keysIter.next();
                    String value = jsonObject.getString(key);
                    result.put(key, value);
                }
            }
        }
        return result;
    }

    public static <T> T firstItem(List<T> items) {
        if (items == null) {
            return null;
        }
        Iterator<T> iterator = items.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static int parseIntSilently(String intString) {
        try {
            return Integer.parseInt(intString);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static String toSHA1HexString(String input) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-1");
            return Util.byteArrayToHexString(md.digest(input.getBytes()));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String byteArrayToHexString(byte[] b) {
        String result = "";
        for (int i = 0; i < b.length; ++i) {
            result = result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }

    public static Integer getNumberOfSecondFromNow(Date date) {
        if (date == null) {
            return 0;
        }
        long now = new Date().getTime();
        long time = date.getTime();
        if (time > now) {
            return (int)(time - now) / 1000;
        }
        return null;
    }
}

