/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.util;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsonorg.JsonOrgModule;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Set;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.bouncycastle.openssl.PEMParser;
import org.gluu.oxauth.model.crypto.Certificate;
import org.gluu.oxauth.model.crypto.PublicKey;
import org.gluu.oxauth.model.crypto.signature.ECDSAPublicKey;
import org.gluu.oxauth.model.crypto.signature.RSAPublicKey;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.oxauth.model.jwt.Jwt;
import org.gluu.oxauth.model.util.Base64Util;
import org.gluu.util.StringHelper;
import org.gluu.util.security.SecurityProviderUtility;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.json.JSONArray;
import org.json.JSONObject;

public class JwtUtil {
    private static final Logger log = Logger.getLogger(JwtUtil.class);

    public static void printAlgorithmsAndProviders() {
        Provider[] providers;
        Set<String> algorithms = Security.getAlgorithms("Signature");
        for (String algorithm : algorithms) {
            log.trace((Object)("Algorithm (Signature): " + algorithm));
        }
        algorithms = Security.getAlgorithms("MessageDigest");
        for (String algorithm : algorithms) {
            log.trace((Object)("Algorithm (MessageDigest): " + algorithm));
        }
        algorithms = Security.getAlgorithms("Cipher");
        for (String algorithm : algorithms) {
            log.trace((Object)("Algorithm (Cipher): " + algorithm));
        }
        algorithms = Security.getAlgorithms("Mac");
        for (String algorithm : algorithms) {
            log.trace((Object)("Algorithm (Mac): " + algorithm));
        }
        algorithms = Security.getAlgorithms("KeyStore");
        for (String algorithm : algorithms) {
            log.trace((Object)("Algorithm (KeyStore): " + algorithm));
        }
        for (Provider provider : providers = Security.getProviders()) {
            log.trace((Object)("Provider: " + provider.getName()));
        }
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexArray = "0123456789abcdef".toCharArray();
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static byte[] getMessageDigestSHA256(String data) throws NoSuchProviderException, NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest mda = MessageDigest.getInstance("SHA-256", SecurityProviderUtility.getBCProvider());
        return mda.digest(data.getBytes("UTF-8"));
    }

    public static byte[] getMessageDigestSHA384(String data) throws NoSuchProviderException, NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest mda = MessageDigest.getInstance("SHA-384", SecurityProviderUtility.getBCProvider());
        return mda.digest(data.getBytes("UTF-8"));
    }

    public static byte[] getMessageDigestSHA512(String data) throws NoSuchProviderException, NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest mda = MessageDigest.getInstance("SHA-512", SecurityProviderUtility.getBCProvider());
        return mda.digest(data.getBytes("UTF-8"));
    }

    public static PublicKey getPublicKey(String jwksUri, String jwks, SignatureAlgorithm signatureAlgorithm, String keyId) {
        log.debug((Object)"Retrieving JWK...");
        JSONObject jsonKeyValue = JwtUtil.getJsonKey(jwksUri, jwks, keyId);
        if (jsonKeyValue == null) {
            return null;
        }
        PublicKey publicKey = null;
        try {
            String resultKeyId = jsonKeyValue.getString("kid");
            if (signatureAlgorithm == null && (signatureAlgorithm = SignatureAlgorithm.fromString(jsonKeyValue.getString("alg"))) == null) {
                log.error((Object)String.format("Failed to determine key '%s' signature algorithm", resultKeyId));
                return null;
            }
            JSONObject jsonPublicKey = jsonKeyValue;
            if (jsonKeyValue.has("publicKey")) {
                jsonPublicKey = jsonKeyValue.getJSONObject("publicKey");
            }
            if (signatureAlgorithm == SignatureAlgorithm.RS256 || signatureAlgorithm == SignatureAlgorithm.RS384 || signatureAlgorithm == SignatureAlgorithm.RS512) {
                String exp = jsonPublicKey.getString("e");
                String mod = jsonPublicKey.getString("n");
                BigInteger publicExponent = new BigInteger(1, Base64Util.base64urldecode(exp));
                BigInteger modulus = new BigInteger(1, Base64Util.base64urldecode(mod));
                publicKey = new RSAPublicKey(modulus, publicExponent);
            } else if (signatureAlgorithm == SignatureAlgorithm.ES256 || signatureAlgorithm == SignatureAlgorithm.ES384 || signatureAlgorithm == SignatureAlgorithm.ES512) {
                String xx = jsonPublicKey.getString("x");
                String yy = jsonPublicKey.getString("y");
                BigInteger x = new BigInteger(1, Base64Util.base64urldecode(xx));
                BigInteger y = new BigInteger(1, Base64Util.base64urldecode(yy));
                publicKey = new ECDSAPublicKey(signatureAlgorithm, x, y);
            }
            if (publicKey != null && jsonKeyValue.has("x5c")) {
                String BEGIN = "-----BEGIN CERTIFICATE-----";
                String END = "-----END CERTIFICATE-----";
                JSONArray certChain = jsonKeyValue.getJSONArray("x5c");
                String certificateString = "-----BEGIN CERTIFICATE-----\n" + certChain.getString(0) + "\n" + "-----END CERTIFICATE-----";
                StringReader sr = new StringReader(certificateString);
                PEMParser pemReader = new PEMParser((Reader)sr);
                X509Certificate cert = (X509Certificate)pemReader.readObject();
                Certificate certificate = new Certificate(signatureAlgorithm, cert);
                publicKey.setCertificate(certificate);
            }
            if (publicKey != null) {
                publicKey.setKeyId(resultKeyId);
                publicKey.setSignatureAlgorithm(signatureAlgorithm);
            }
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return publicKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject getJsonKey(String jwksUri, String jwks, String keyId) {
        JSONObject jsonKey;
        block10: {
            log.debug((Object)"Retrieving JWK Key...");
            jsonKey = null;
            try {
                JSONObject jsonObject;
                JSONArray keys;
                if (StringHelper.isEmpty((String)jwks)) {
                    try (Client clientRequest = ClientBuilder.newClient();){
                        Response clientResponse = clientRequest.target(jwksUri).request().buildGet().invoke();
                        int status = clientResponse.getStatus();
                        log.debug((Object)String.format("Status: %n%d", status));
                        if (status == 200) {
                            jwks = (String)clientResponse.readEntity(String.class);
                            log.debug((Object)String.format("JWK: %s", jwks));
                        }
                    }
                }
                if (!StringHelper.isNotEmpty((String)jwks) || (keys = (jsonObject = new JSONObject(jwks)).getJSONArray("keys")).length() <= 0) break block10;
                if (StringHelper.isEmpty((String)keyId)) {
                    jsonKey = keys.getJSONObject(0);
                    break block10;
                }
                for (int i = 0; i < keys.length(); ++i) {
                    JSONObject kv = keys.getJSONObject(i);
                    if (!kv.getString("kid").equals(keyId)) continue;
                    jsonKey = kv;
                    break;
                }
            }
            catch (Exception ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return jsonKey;
    }

    public static JSONObject getJSONWebKeys(String jwksUri) {
        return JwtUtil.getJSONWebKeys(jwksUri, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject getJSONWebKeys(String jwksUri, ClientHttpEngine engine) {
        JSONObject jwks;
        block7: {
            log.debug((Object)("Retrieving jwks " + jwksUri + "..."));
            jwks = null;
            try {
                if (StringHelper.isEmpty((String)jwksUri)) break block7;
                ClientBuilder clientBuilder = ResteasyClientBuilder.newBuilder();
                if (engine != null) {
                    ((ResteasyClientBuilder)clientBuilder).httpEngine(engine);
                }
                try (Client clientRequest = clientBuilder.build();){
                    Response clientResponse = clientRequest.target(jwksUri).request().buildGet().invoke();
                    int status = clientResponse.getStatus();
                    log.debug((Object)String.format("Status: %n%d", status));
                    if (status == 200) {
                        jwks = JwtUtil.fromJson((String)clientResponse.readEntity(String.class));
                        log.debug((Object)String.format("JWK: %s", jwks));
                    }
                }
            }
            catch (Exception ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return jwks;
    }

    public static JSONObject fromJson(String json) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JsonOrgModule());
        return (JSONObject)mapper.readValue(json, JSONObject.class);
    }

    public static void transferIntoJwtClaims(JSONObject jsonObject, Jwt jwt) {
        if (jsonObject == null || jwt == null) {
            return;
        }
        for (String key : jsonObject.keySet()) {
            Object value = jsonObject.opt(key);
            jwt.getClaims().setClaimObject(key, value, true);
        }
    }
}

