/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.util;

import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.oxauth.model.util.Base64Util;
import org.gluu.oxauth.model.util.JwtUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashUtil {
    private static final Logger log = LoggerFactory.getLogger(HashUtil.class);

    private HashUtil() {
    }

    public static String getHash(String input, SignatureAlgorithm signatureAlgorithm) {
        try {
            byte[] digest = signatureAlgorithm == SignatureAlgorithm.HS256 || signatureAlgorithm == SignatureAlgorithm.RS256 || signatureAlgorithm == SignatureAlgorithm.PS256 || signatureAlgorithm == SignatureAlgorithm.ES256 ? JwtUtil.getMessageDigestSHA256(input) : (signatureAlgorithm == SignatureAlgorithm.HS384 || signatureAlgorithm == SignatureAlgorithm.RS384 || signatureAlgorithm == SignatureAlgorithm.PS384 || signatureAlgorithm == SignatureAlgorithm.ES384 ? JwtUtil.getMessageDigestSHA384(input) : (signatureAlgorithm == SignatureAlgorithm.HS512 || signatureAlgorithm == SignatureAlgorithm.RS512 || signatureAlgorithm == SignatureAlgorithm.PS512 || signatureAlgorithm == SignatureAlgorithm.ES512 ? JwtUtil.getMessageDigestSHA512(input) : JwtUtil.getMessageDigestSHA256(input)));
            if (digest != null) {
                byte[] lefMostHalf = new byte[digest.length / 2];
                System.arraycopy(digest, 0, lefMostHalf, 0, lefMostHalf.length);
                return Base64Util.base64urlencode(lefMostHalf);
            }
        }
        catch (Exception e) {
            log.error("Failed to calculate hash.", (Throwable)e);
        }
        return null;
    }
}

