/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.util;

import java.io.ByteArrayInputStream;
import java.security.AlgorithmParameters;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.util.encoders.Base64;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.oxauth.model.util.Base64Util;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertUtils {
    private static final Logger log = LoggerFactory.getLogger(CertUtils.class);

    private CertUtils() {
    }

    public static SignatureAlgorithm getSignatureAlgorithm(X509Certificate cert) {
        String signAlgName = cert.getSigAlgName();
        for (SignatureAlgorithm sa : SignatureAlgorithm.values()) {
            if (!signAlgName.equalsIgnoreCase(sa.getAlgorithm())) continue;
            return sa;
        }
        if ("RSASSA-PSS".equals(signAlgName)) {
            AlgorithmParameters algorithmParameters = CertUtils.getAlgorithmParameters(cert);
            if (algorithmParameters == null) {
                return null;
            }
            String algParamString = algorithmParameters.toString();
            if (algParamString.contains("SHA-256")) {
                return SignatureAlgorithm.PS256;
            }
            if (algParamString.contains("SHA-384")) {
                return SignatureAlgorithm.PS384;
            }
            if (algParamString.contains("SHA-512")) {
                return SignatureAlgorithm.PS512;
            }
        }
        return null;
    }

    public static AlgorithmParameters getAlgorithmParameters(X509Certificate cert) {
        try {
            AlgorithmParameters result = AlgorithmParameters.getInstance(cert.getSigAlgName());
            result.init(cert.getSigAlgParams());
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static X509Certificate x509CertificateFromBytes(byte[] cert) {
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bais = new ByteArrayInputStream(cert);
            return (X509Certificate)certFactory.generateCertificate(bais);
        }
        catch (Exception ex) {
            log.error("Failed to parse X.509 certificates from bytes", (Throwable)ex);
            return null;
        }
    }

    public static X509Certificate x509CertificateFromPem(String pem) {
        pem = StringUtils.remove((String)pem, (String)"-----BEGIN CERTIFICATE-----");
        pem = StringUtils.remove((String)pem, (String)"-----END CERTIFICATE-----");
        return CertUtils.x509CertificateFromBytes(Base64.decode((String)pem));
    }

    public static String confirmationMethodHashS256(String certificateAsPem) {
        if (StringUtils.isBlank((String)certificateAsPem)) {
            return "";
        }
        try {
            certificateAsPem = StringUtils.remove((String)certificateAsPem, (String)"-----BEGIN CERTIFICATE-----");
            certificateAsPem = StringUtils.remove((String)certificateAsPem, (String)"-----END CERTIFICATE-----");
            certificateAsPem = StringUtils.replace((String)certificateAsPem, (String)"\n", (String)"");
            return Base64Util.base64urlencode(DigestUtils.sha256((byte[])Base64.decode((String)certificateAsPem)));
        }
        catch (Exception e) {
            log.error("Failed to hash certificate: " + certificateAsPem, (Throwable)e);
            return "";
        }
    }

    @NotNull
    public static String getCN(@Nullable X509Certificate cert) {
        try {
            if (cert == null) {
                return "";
            }
            X500Name x500name = new JcaX509CertificateHolder(cert).getSubject();
            RDN[] rdns = x500name.getRDNs(BCStyle.CN);
            if (rdns == null || rdns.length == 0) {
                return "";
            }
            RDN cn = rdns[0];
            if (cn != null && cn.getFirst() != null && cn.getFirst().getValue() != null) {
                return IETFUtils.valueToString((ASN1Encodable)cn.getFirst().getValue());
            }
        }
        catch (CertificateEncodingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return "";
    }

    public static boolean equalsRdn(String rdn1, String rdn2) {
        if (StringUtils.isBlank((String)rdn1) || StringUtils.isBlank((String)rdn2)) {
            return false;
        }
        X500Name n1 = new X500Name(rdn1);
        X500Name n2 = new X500Name(rdn2);
        return n1.equals((Object)n2);
    }
}

