/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.uma.persistence;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gluu.oxauth.model.util.Pair;
import org.gluu.oxauth.model.util.Util;
import org.gluu.persist.annotation.AttributeName;
import org.gluu.persist.annotation.DN;
import org.gluu.persist.annotation.DataEntry;
import org.gluu.persist.annotation.Expiration;
import org.gluu.persist.annotation.JsonObject;
import org.gluu.persist.annotation.ObjectClass;

@DataEntry
@ObjectClass(value="oxUmaResourcePermission")
public class UmaPermission
implements Serializable {
    public static final String PCT = "pct";
    @DN
    private String dn;
    @AttributeName(name="oxStatus")
    private String status;
    @AttributeName(name="oxTicket", consistency=true)
    private String ticket;
    @AttributeName(name="oxConfigurationCode")
    private String configurationCode;
    @AttributeName(name="exp")
    private Date expirationDate;
    @AttributeName(name="del")
    private boolean deletable = true;
    @AttributeName(name="oxResourceSetId")
    private String resourceId;
    @AttributeName(name="oxAuthUmaScope")
    private List<String> scopeDns;
    @JsonObject
    @AttributeName(name="oxAttributes")
    private Map<String, String> attributes;
    @Expiration
    private Integer ttl;
    private boolean expired;

    public UmaPermission() {
    }

    public UmaPermission(String resourceId, List<String> scopes, String ticket, String configurationCode, Pair<Date, Integer> expirationDate) {
        this.resourceId = resourceId;
        this.scopeDns = scopes;
        this.ticket = ticket;
        this.configurationCode = configurationCode;
        this.expirationDate = expirationDate.getFirst();
        this.ttl = expirationDate.getSecond();
        this.checkExpired();
    }

    public Integer getTtl() {
        return this.ttl;
    }

    public void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

    public void resetTtlFromExpirationDate() {
        Integer ttl = Util.getNumberOfSecondFromNow(this.getExpirationDate());
        if (ttl != null) {
            this.setTtl(ttl);
        }
    }

    public String getDn() {
        return this.dn;
    }

    public void setDn(String p_dn) {
        this.dn = p_dn;
    }

    public boolean isDeletable() {
        return this.deletable;
    }

    public void setDeletable(boolean deletable) {
        this.deletable = deletable;
    }

    public void checkExpired() {
        this.checkExpired(new Date());
    }

    public void checkExpired(Date now) {
        if (now.after(this.expirationDate) && this.deletable) {
            this.expired = true;
        }
    }

    public boolean isValid() {
        return !this.expired;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getConfigurationCode() {
        return this.configurationCode;
    }

    public void setConfigurationCode(String configurationCode) {
        this.configurationCode = configurationCode;
    }

    public String getTicket() {
        return this.ticket;
    }

    public void setTicket(String ticket) {
        this.ticket = ticket;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public List<String> getScopeDns() {
        if (this.scopeDns == null) {
            this.scopeDns = new ArrayList<String>();
        }
        return this.scopeDns;
    }

    public void setScopeDns(List<String> p_scopeDns) {
        this.scopeDns = p_scopeDns;
    }

    public Map<String, String> getAttributes() {
        if (this.attributes == null) {
            this.attributes = Maps.newHashMap();
        }
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes != null ? attributes : new HashMap();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UmaPermission that = (UmaPermission)o;
        return !(this.ticket == null ? that.ticket != null : !this.ticket.equals(that.ticket));
    }

    public int hashCode() {
        return this.ticket != null ? this.ticket.hashCode() : 0;
    }

    public String toString() {
        return "UmaPermission{dn='" + this.dn + '\'' + ", status='" + this.status + '\'' + ", ticket='" + this.ticket + '\'' + ", configurationCode='" + this.configurationCode + '\'' + ", expirationDate=" + this.expirationDate + ", resourceId='" + this.resourceId + '\'' + ", scopeDns=" + this.scopeDns + ", expired=" + this.expired + '}';
    }
}

