/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.uma;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.model.uma.JsonLogicNodeParser;
import org.jboss.resteasy.annotations.providers.jaxb.IgnoreMediaTypes;

@IgnoreMediaTypes(value={"application/*+json"})
@JsonPropertyOrder(value={"name", "uri", "type", "scopes", "scopeExpression", "icon_uri"})
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
public class UmaResource {
    private List<String> scopes;
    private String scopeExpression;
    private String description;
    private String iconUri;
    private String name;
    private String type;
    private Integer iat;
    private Integer exp;

    @JsonProperty(value="iat")
    @XmlElement(name="iat")
    public Integer getIat() {
        return this.iat;
    }

    public void setIat(Integer iat) {
        this.iat = iat;
    }

    @JsonProperty(value="exp")
    @XmlElement(name="exp")
    public Integer getExp() {
        return this.exp;
    }

    public void setExp(Integer exp) {
        this.exp = exp;
    }

    @JsonProperty(value="description")
    @XmlElement(name="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="type")
    @XmlElement(name="type")
    public String getType() {
        return this.type;
    }

    public UmaResource setType(String p_type) {
        this.type = p_type;
        return this;
    }

    @JsonProperty(value="name")
    @XmlElement(name="name")
    public String getName() {
        return this.name;
    }

    public UmaResource setName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="icon_uri")
    @XmlElement(name="icon_uri")
    public String getIconUri() {
        return this.iconUri;
    }

    public UmaResource setIconUri(String iconUri) {
        this.iconUri = iconUri;
        return this;
    }

    @JsonProperty(value="resource_scopes")
    @XmlElement(name="resource_scopes")
    public List<String> getScopes() {
        return this.scopes;
    }

    public UmaResource setScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    @JsonProperty(value="scope_expression")
    @XmlElement(name="scope_expression")
    public String getScopeExpression() {
        return this.scopeExpression;
    }

    public void setScopeExpression(String scopeExpression) {
        UmaResource.assertValidExpression(scopeExpression);
        this.scopeExpression = scopeExpression;
    }

    @JsonIgnore
    public static void assertValidExpression(String scopeExpression) {
        if (!UmaResource.isValidExpression(scopeExpression)) {
            throw new RuntimeException("Scope expression is not valid json logic expression. Expression:" + scopeExpression);
        }
    }

    @JsonIgnore
    public static boolean isValidExpression(String scopeExpression) {
        return StringUtils.isBlank((String)scopeExpression) || JsonLogicNodeParser.isNodeValid(scopeExpression);
    }

    public String toString() {
        return "UmaResource{name='" + this.name + '\'' + ", scopes=" + this.scopes + ", scopeExpression=" + this.scopeExpression + ", description='" + this.description + '\'' + ", iconUri='" + this.iconUri + '\'' + ", type='" + this.type + '\'' + '}';
    }
}

