/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.register;

import org.apache.commons.lang.StringUtils;

public enum RegisterRequestParam {
    REDIRECT_URIS("redirect_uris"),
    CLAIMS_REDIRECT_URIS("claims_redirect_uri"),
    RESPONSE_TYPES("response_types"),
    GRANT_TYPES("grant_types"),
    APPLICATION_TYPE("application_type"),
    CONTACTS("contacts"),
    CLIENT_NAME("client_name"),
    LOGO_URI("logo_uri"),
    CLIENT_URI("client_uri"),
    POLICY_URI("policy_uri"),
    TOS_URI("tos_uri"),
    JWKS_URI("jwks_uri"),
    JWKS("jwks"),
    SECTOR_IDENTIFIER_URI("sector_identifier_uri"),
    SUBJECT_TYPE("subject_type"),
    RPT_AS_JWT("rpt_as_jwt"),
    ACCESS_TOKEN_AS_JWT("access_token_as_jwt"),
    ACCESS_TOKEN_SIGNING_ALG("access_token_signing_alg"),
    ID_TOKEN_SIGNED_RESPONSE_ALG("id_token_signed_response_alg"),
    ID_TOKEN_ENCRYPTED_RESPONSE_ALG("id_token_encrypted_response_alg"),
    ID_TOKEN_ENCRYPTED_RESPONSE_ENC("id_token_encrypted_response_enc"),
    USERINFO_SIGNED_RESPONSE_ALG("userinfo_signed_response_alg"),
    USERINFO_ENCRYPTED_RESPONSE_ALG("userinfo_encrypted_response_alg"),
    USERINFO_ENCRYPTED_RESPONSE_ENC("userinfo_encrypted_response_enc"),
    REQUEST_OBJECT_SIGNING_ALG("request_object_signing_alg"),
    REQUEST_OBJECT_ENCRYPTION_ALG("request_object_encryption_alg"),
    REQUEST_OBJECT_ENCRYPTION_ENC("request_object_encryption_enc"),
    TOKEN_ENDPOINT_AUTH_METHOD("token_endpoint_auth_method"),
    TOKEN_ENDPOINT_AUTH_SIGNING_ALG("token_endpoint_auth_signing_alg"),
    DEFAULT_MAX_AGE("default_max_age"),
    REQUIRE_AUTH_TIME("require_auth_time"),
    DEFAULT_ACR_VALUES("default_acr_values"),
    INITIATE_LOGIN_URI("initiate_login_uri"),
    POST_LOGOUT_REDIRECT_URIS("post_logout_redirect_uris"),
    FRONT_CHANNEL_LOGOUT_URI("frontchannel_logout_uri"),
    FRONT_CHANNEL_LOGOUT_SESSION_REQUIRED("frontchannel_logout_session_required"),
    BACKCHANNEL_LOGOUT_URI("backchannel_logout_uri"),
    BACKCHANNEL_LOGOUT_SESSION_REQUIRED("backchannel_logout_session_required"),
    REQUEST_URIS("request_uris"),
    SCOPES("scopes"),
    CLAIMS("claims"),
    ID_TOKEN_TOKEN_BINDING_CNF("id_token_token_binding_cnf"),
    TLS_CLIENT_AUTH_SUBJECT_DN("tls_client_auth_subject_dn"),
    ALLOW_SPONTANEOUS_SCOPES("allow_spontaneous_scopes"),
    SPONTANEOUS_SCOPES("spontaneous_scopes"),
    RUN_INTROSPECTION_SCRIPT_BEFORE_ACCESS_TOKEN_CREATION_AS_JWT_AND_INCLUDE_CLAIMS("run_introspection_script_before_access_token_as_jwt_creation_and_include_claims"),
    KEEP_CLIENT_AUTHORIZATION_AFTER_EXPIRATION("keep_client_authorization_after_expiration"),
    SCOPE("scope"),
    AUTHORIZED_ORIGINS("authorized_origins"),
    ACCESS_TOKEN_LIFETIME("access_token_lifetime"),
    SOFTWARE_ID("software_id"),
    SOFTWARE_VERSION("software_version"),
    SOFTWARE_STATEMENT("software_statement"),
    BACKCHANNEL_TOKEN_DELIVERY_MODE("backchannel_token_delivery_mode"),
    BACKCHANNEL_CLIENT_NOTIFICATION_ENDPOINT("backchannel_client_notification_endpoint"),
    BACKCHANNEL_AUTHENTICATION_REQUEST_SIGNING_ALG("backchannel_authentication_request_signing_alg"),
    BACKCHANNEL_USER_CODE_PARAMETER("backchannel_user_code_parameter");

    private final String name;

    private RegisterRequestParam(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static boolean isStandard(String p_parameterName) {
        if (StringUtils.isNotBlank((String)p_parameterName)) {
            for (RegisterRequestParam t : RegisterRequestParam.values()) {
                if (!t.getName().equalsIgnoreCase(p_parameterName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isCustomParameterValid(String p_parameterName) {
        return StringUtils.isNotBlank((String)p_parameterName) && !RegisterRequestParam.isStandard(p_parameterName);
    }

    public String toString() {
        return this.name;
    }
}

