/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.jwt;

import org.gluu.oxauth.model.crypto.encryption.BlockEncryptionAlgorithm;
import org.gluu.oxauth.model.crypto.encryption.KeyEncryptionAlgorithm;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.oxauth.model.exception.InvalidJwtException;
import org.gluu.oxauth.model.jwt.JwtClaimSet;
import org.gluu.oxauth.model.jwt.JwtType;
import org.json.JSONObject;

public class JwtHeader
extends JwtClaimSet {
    public JwtHeader() {
    }

    public JwtHeader(JSONObject jsonObject) {
        super(jsonObject);
    }

    public JwtHeader(String base64JsonObject) throws InvalidJwtException {
        super(base64JsonObject);
    }

    public static JwtHeader instance() {
        return new JwtHeader();
    }

    public JwtHeader setType(JwtType type) {
        if (type == null) {
            this.setNullClaim("typ");
        } else {
            this.setClaim("typ", type.toString());
        }
        return this;
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        String alg = this.getClaimAsString("alg");
        return SignatureAlgorithm.fromString(alg);
    }

    public JwtHeader setAlgorithm(SignatureAlgorithm algorithm) {
        if (algorithm == null) {
            this.setNullClaim("alg");
        } else {
            this.setClaim("alg", algorithm.toString());
        }
        return this;
    }

    public JwtHeader setAlgorithm(KeyEncryptionAlgorithm algorithm) {
        if (algorithm == null) {
            this.setNullClaim("alg");
        } else {
            this.setClaim("alg", algorithm.toString());
        }
        return this;
    }

    public String getKeyId() {
        String keyId = this.getClaimAsString("kid");
        return keyId;
    }

    public JwtHeader setKeyId(String keyId) {
        this.setClaim("kid", keyId);
        return this;
    }

    public void setContentType(JwtType contentType) {
        if (contentType == null) {
            this.setNullClaim("cty");
        } else {
            this.setClaim("cty", contentType.toString());
        }
    }

    public JwtType getContentType() {
        return JwtType.fromString(this.getClaimAsString("cty"));
    }

    public void setEncryptionMethod(BlockEncryptionAlgorithm encryptionMethod) {
        if (encryptionMethod == null) {
            this.setNullClaim("enc");
        } else {
            this.setClaim("enc", encryptionMethod.toString());
        }
    }

    public BlockEncryptionAlgorithm getEncryptionMethod() {
        return BlockEncryptionAlgorithm.fromName(this.getClaimAsString("enc"));
    }

    public void setEphemeralPublicKey(String ephemeralPublicKey) {
        this.setClaim("epk", ephemeralPublicKey);
    }

    public void setCompressionAlgorithm(String compressionAlgorithm) {
        this.setClaim("zip", compressionAlgorithm);
    }

    public void setAgreementPartyUInfo(String agreementPartyUInfo) {
        this.setClaim("apu", agreementPartyUInfo);
    }

    public void setAgreementPartyVInfo(String agreementPartyVInfo) {
        this.setClaim("apv", agreementPartyVInfo);
    }

    public void setEncryptionPartyUInfo(String encryptionPartyUInfo) {
        this.setClaim("epu", encryptionPartyUInfo);
    }

    public void setEncryptionPartyVInfo(String encryptionPartyVInfo) {
        this.setClaim("epv", encryptionPartyVInfo);
    }
}

