/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.jwt;

import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gluu.oxauth.model.exception.InvalidJwtException;
import org.gluu.oxauth.model.json.JsonApplier;
import org.gluu.oxauth.model.jwt.JwtSubClaimObject;
import org.gluu.oxauth.model.util.Base64Util;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class JwtClaimSet {
    private Map<String, Object> claims = new LinkedHashMap<String, Object>();

    public JwtClaimSet() {
    }

    public JwtClaimSet(JSONObject jsonObject) {
        this();
        this.load(jsonObject);
    }

    public JwtClaimSet(String base64JsonObject) throws InvalidJwtException {
        this();
        this.load(base64JsonObject);
    }

    public Set<String> keys() {
        return this.claims.keySet();
    }

    public Object getClaim(String key) {
        return this.claims.get(key);
    }

    public boolean hasClaim(String key) {
        return this.getClaim(key) != null;
    }

    public String getClaimAsString(String key) {
        Object claim = this.getClaim(key);
        if (claim != null) {
            return claim.toString();
        }
        return null;
    }

    public JSONObject getClaimAsJSON(String key) {
        String claim = this.getClaimAsString(key);
        try {
            if (claim != null) {
                JSONObject json = null;
                json = new JSONObject(claim);
                return json;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }

    public List<String> getClaimAsStringList(String key) {
        ArrayList<String> list = new ArrayList<String>();
        Object claims = this.getClaim(key);
        try {
            if (claims != null && claims instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)claims;
                for (int i = 0; i < jsonArray.length(); ++i) {
                    list.add(jsonArray.getString(i));
                }
            } else {
                String claim = this.getClaimAsString(key);
                if (claim != null) {
                    list.add(claim);
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return list;
    }

    public Date getClaimAsDate(String key) {
        Object claim = this.getClaim(key);
        if (claim != null) {
            if (claim instanceof Date) {
                return (Date)claim;
            }
            if (claim instanceof Integer) {
                long c = ((Integer)claim).intValue();
                long date = c * 1000L;
                return new Date(date);
            }
            if (claim instanceof Long) {
                return new Date((Long)claim * 1000L);
            }
            if (claim instanceof Double) {
                double c = (Double)claim;
                BigDecimal bigDecimal = new BigDecimal(c);
                long claimLong = bigDecimal.longValue();
                return new Date(claimLong *= 1000L);
            }
            return null;
        }
        return null;
    }

    public Integer getClaimAsInteger(String key) {
        Object claim = this.getClaim(key);
        if (claim != null) {
            if (claim instanceof Integer) {
                return (Integer)claim;
            }
            return null;
        }
        return null;
    }

    public Long getClaimAsLong(String key) {
        Object claim = this.getClaim(key);
        if (claim != null) {
            if (claim instanceof Long) {
                return (Long)claim;
            }
            return null;
        }
        return null;
    }

    public Character getClaimAsCharacter(String key) {
        Object claim = this.getClaim(key);
        if (claim != null) {
            if (claim instanceof Character) {
                return (Character)claim;
            }
            return null;
        }
        return null;
    }

    public void setClaimObject(String key, Object value, boolean overrideValue) {
        if (value == null) {
            this.setNullClaim(key);
        } else if (value instanceof String) {
            if (overrideValue) {
                this.setClaim(key, (String)value);
            } else {
                Object currentValue = this.getClaim(key);
                if (currentValue != null) {
                    this.setClaim(key, Lists.newArrayList((Object[])new String[]{currentValue.toString(), (String)value}));
                } else {
                    this.setClaim(key, (String)value);
                }
            }
        } else if (value instanceof Date) {
            this.setClaim(key, (Date)value);
        } else if (value instanceof Boolean) {
            this.setClaim(key, (Boolean)value);
        } else if (value instanceof Integer) {
            this.setClaim(key, (Integer)value);
        } else if (value instanceof Long) {
            this.setClaim(key, (Long)value);
        } else if (value instanceof Character) {
            this.setClaim(key, (Character)value);
        } else if (value instanceof List) {
            this.setClaim(key, (List)value);
        } else if (value instanceof JwtSubClaimObject) {
            this.setClaim(key, (JwtSubClaimObject)value);
        } else if (value instanceof JSONObject) {
            this.setClaim(key, (JSONObject)value);
        } else if (value instanceof JSONArray) {
            this.setClaim(key, (JSONArray)value);
        } else {
            throw new UnsupportedOperationException("Claim value is not supported, key: " + key + ", value :" + value);
        }
    }

    public void setNullClaim(String key) {
        this.claims.put(key, null);
    }

    public void setClaim(String key, String value) {
        this.claims.put(key, value);
    }

    public void setClaim(String key, Date value) {
        this.claims.put(key, value);
    }

    public void setClaim(String key, Boolean value) {
        this.claims.put(key, value);
    }

    public void setClaim(String key, Integer value) {
        this.claims.put(key, value);
    }

    public void setClaim(String key, Long value) {
        this.claims.put(key, value);
    }

    public void setClaim(String key, Character value) {
        this.claims.put(key, value);
    }

    public void setClaim(String key, List values) {
        this.claims.put(key, values);
    }

    public void setClaim(String key, JwtSubClaimObject subClaimObject) {
        this.claims.put(key, subClaimObject);
    }

    public void setClaim(String key, JSONObject values) {
        this.claims.put(key, values);
    }

    public void setClaim(String key, JSONArray values) {
        this.claims.put(key, values);
    }

    public void setClaimFromJsonObject(String key, Object attribute) {
        if (attribute == null) {
            return;
        }
        if (attribute instanceof JSONArray) {
            this.claims.put(key, JsonApplier.getStringList((JSONArray)attribute));
        } else {
            String value = (String)attribute;
            this.claims.put(key, value);
        }
    }

    public void removeClaim(String key) {
        this.claims.remove(key);
    }

    public JSONObject toJsonObject() throws InvalidJwtException {
        JSONObject jsonObject = new JSONObject();
        try {
            for (Map.Entry<String, Object> claim : this.claims.entrySet()) {
                if (claim.getValue() instanceof Date) {
                    Date date = (Date)claim.getValue();
                    jsonObject.put(claim.getKey(), date.getTime() / 1000L);
                    continue;
                }
                if (claim.getValue() instanceof JwtSubClaimObject) {
                    JwtSubClaimObject subClaimObject = (JwtSubClaimObject)claim.getValue();
                    jsonObject.put(subClaimObject.getName(), (Object)subClaimObject.toJsonObject());
                    continue;
                }
                if (claim.getValue() instanceof List) {
                    List claimObjectList = (List)claim.getValue();
                    JSONArray claimsJSONArray = new JSONArray();
                    for (Object claimObj : claimObjectList) {
                        claimsJSONArray.put(claimObj);
                    }
                    jsonObject.put(claim.getKey(), (Object)claimsJSONArray);
                    continue;
                }
                jsonObject.put(claim.getKey(), claim.getValue());
            }
        }
        catch (JSONException e) {
            throw new InvalidJwtException(e);
        }
        catch (Exception e) {
            throw new InvalidJwtException(e);
        }
        return jsonObject;
    }

    public String toBase64JsonObject() throws InvalidJwtException {
        try {
            String jsonObjectString = this.toJsonString();
            byte[] jsonObjectBytes = jsonObjectString.getBytes("UTF-8");
            return Base64Util.base64urlencode(jsonObjectBytes);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public String toJsonString() throws InvalidJwtException {
        JSONObject jsonObject = this.toJsonObject();
        String jsonObjectString = jsonObject.toString();
        jsonObjectString = jsonObjectString.replace("\\/", "/");
        return jsonObjectString;
    }

    public Map<String, List<String>> toMap() throws InvalidJwtException {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        try {
            for (Map.Entry<String, Object> claim : this.claims.entrySet()) {
                String key = claim.getKey();
                Object value = claim.getValue();
                ArrayList<String> values = new ArrayList<String>();
                if (value instanceof JSONArray) {
                    JSONArray jsonArray = (JSONArray)value;
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        values.add(jsonArray.getString(i));
                    }
                } else if (value != null) {
                    values.add(value.toString());
                }
                map.put(key, values);
            }
        }
        catch (JSONException e) {
            throw new InvalidJwtException(e);
        }
        return map;
    }

    public void load(JSONObject jsonObject) {
        this.claims.clear();
        Iterator it = jsonObject.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = jsonObject.opt(key);
            this.claims.put(key, value);
        }
    }

    public void load(String base64JsonObject) throws InvalidJwtException {
        try {
            String jsonObjectString = new String(Base64Util.base64urldecode(base64JsonObject), "UTF-8");
            this.load(new JSONObject(jsonObjectString));
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidJwtException(e);
        }
        catch (JSONException e) {
            throw new InvalidJwtException(e);
        }
        catch (Exception e) {
            throw new InvalidJwtException(e);
        }
    }
}

