/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.jws;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.oxauth.model.jws.AbstractJwsSigner;
import org.gluu.oxauth.model.util.Base64Util;
import org.gluu.oxauth.model.util.StringUtils;

public class HMACSigner
extends AbstractJwsSigner {
    private String sharedSecret;

    public HMACSigner(SignatureAlgorithm signatureAlgorithm, String sharedSecret) {
        super(signatureAlgorithm);
        this.sharedSecret = sharedSecret;
    }

    @Override
    public String generateSignature(String signingInput) throws SignatureException {
        String algorithm;
        if (this.getSignatureAlgorithm() == null) {
            throw new SignatureException("The signature algorithm is null");
        }
        if (this.sharedSecret == null) {
            throw new SignatureException("The shared secret is null");
        }
        if (signingInput == null) {
            throw new SignatureException("The signing input is null");
        }
        switch (this.getSignatureAlgorithm()) {
            case HS256: {
                algorithm = "HMACSHA256";
                break;
            }
            case HS384: {
                algorithm = "HMACSHA384";
                break;
            }
            case HS512: {
                algorithm = "HMACSHA512";
                break;
            }
            default: {
                throw new SignatureException("Unsupported signature algorithm");
            }
        }
        try {
            SecretKeySpec secretKey = new SecretKeySpec(this.sharedSecret.getBytes("UTF-8"), algorithm);
            Mac mac = Mac.getInstance(algorithm);
            mac.init(secretKey);
            byte[] sig = mac.doFinal(signingInput.getBytes("UTF-8"));
            return Base64Util.base64urlencode(sig);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SignatureException(e);
        }
        catch (InvalidKeyException e) {
            throw new SignatureException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new SignatureException(e);
        }
        catch (Exception e) {
            throw new SignatureException(e);
        }
    }

    @Override
    public boolean validateSignature(String signingInput, String signature) throws SignatureException {
        String expectedSignature = this.generateSignature(signingInput);
        return StringUtils.nullToEmpty(signature).equals(StringUtils.nullToEmpty(expectedSignature));
    }
}

