/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.jws;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.crypto.impl.ECDSA;
import java.io.UnsupportedEncodingException;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import org.gluu.oxauth.model.crypto.Certificate;
import org.gluu.oxauth.model.crypto.signature.AlgorithmFamily;
import org.gluu.oxauth.model.crypto.signature.ECDSAPrivateKey;
import org.gluu.oxauth.model.crypto.signature.ECDSAPublicKey;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.oxauth.model.jws.AbstractJwsSigner;
import org.gluu.oxauth.model.util.Base64Util;
import org.gluu.util.security.SecurityProviderUtility;

public class ECDSASigner
extends AbstractJwsSigner {
    private ECDSAPrivateKey ecdsaPrivateKey;
    private ECDSAPublicKey ecdsaPublicKey;

    public ECDSASigner(SignatureAlgorithm signatureAlgorithm, ECDSAPrivateKey ecdsaPrivateKey) {
        super(signatureAlgorithm);
        this.ecdsaPrivateKey = ecdsaPrivateKey;
    }

    public ECDSASigner(SignatureAlgorithm signatureAlgorithm, ECDSAPublicKey ecdsaPublicKey) {
        super(signatureAlgorithm);
        this.ecdsaPublicKey = ecdsaPublicKey;
    }

    public ECDSASigner(SignatureAlgorithm signatureAlgorithm, Certificate certificate) {
        super(signatureAlgorithm);
        this.ecdsaPublicKey = certificate.getEcdsaPublicKey();
    }

    @Override
    public String generateSignature(String signingInput) throws SignatureException {
        if (this.getSignatureAlgorithm() == null) {
            throw new SignatureException("The signature algorithm is null");
        }
        if (this.ecdsaPrivateKey == null) {
            throw new SignatureException("The ECDSA private key is null");
        }
        if (signingInput == null) {
            throw new SignatureException("The signing input is null");
        }
        try {
            AlgorithmParameters parameters = AlgorithmParameters.getInstance("EC", SecurityProviderUtility.getBCProvider());
            parameters.init(new ECGenParameterSpec(this.getSignatureAlgorithm().getCurve().getName()));
            ECParameterSpec ecParameters = parameters.getParameterSpec(ECParameterSpec.class);
            ECPrivateKeySpec privateKeySpec = new ECPrivateKeySpec(this.ecdsaPrivateKey.getD(), ecParameters);
            KeyFactory keyFactory = KeyFactory.getInstance("EC", SecurityProviderUtility.getBCProvider());
            PrivateKey privateKey = keyFactory.generatePrivate(privateKeySpec);
            Signature signer = Signature.getInstance(this.getSignatureAlgorithm().getAlgorithm(), SecurityProviderUtility.getBCProvider());
            signer.initSign(privateKey);
            signer.update(signingInput.getBytes("UTF-8"));
            byte[] signature = signer.sign();
            if (AlgorithmFamily.EC.equals((Object)this.getSignatureAlgorithm().getFamily())) {
                int signatureLenght = ECDSA.getSignatureByteArrayLength((JWSAlgorithm)JWSAlgorithm.parse((String)this.getSignatureAlgorithm().getName()));
                signature = ECDSA.transcodeSignatureToConcat((byte[])signature, (int)signatureLenght);
            }
            return Base64Util.base64urlencode(signature);
        }
        catch (InvalidKeySpecException e) {
            throw new SignatureException(e);
        }
        catch (InvalidKeyException e) {
            throw new SignatureException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SignatureException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new SignatureException(e);
        }
        catch (Exception e) {
            throw new SignatureException(e);
        }
    }

    @Override
    public boolean validateSignature(String signingInput, String signature) throws SignatureException {
        String algorithm;
        if (this.getSignatureAlgorithm() == null) {
            throw new SignatureException("The signature algorithm is null");
        }
        if (this.ecdsaPublicKey == null) {
            throw new SignatureException("The ECDSA public key is null");
        }
        if (signingInput == null) {
            throw new SignatureException("The signing input is null");
        }
        switch (this.getSignatureAlgorithm()) {
            case ES256: {
                algorithm = "SHA256WITHECDSA";
                break;
            }
            case ES384: {
                algorithm = "SHA384WITHECDSA";
                break;
            }
            case ES512: {
                algorithm = "SHA512WITHECDSA";
                break;
            }
            default: {
                throw new SignatureException("Unsupported signature algorithm");
            }
        }
        try {
            byte[] sigBytes = Base64Util.base64urldecode(signature);
            if (AlgorithmFamily.EC.equals((Object)this.getSignatureAlgorithm().getFamily())) {
                sigBytes = ECDSA.transcodeSignatureToDER((byte[])sigBytes);
            }
            byte[] sigInBytes = signingInput.getBytes("UTF-8");
            AlgorithmParameters parameters = AlgorithmParameters.getInstance("EC", SecurityProviderUtility.getBCProvider());
            parameters.init(new ECGenParameterSpec(this.getSignatureAlgorithm().getCurve().getName()));
            ECParameterSpec ecParameters = parameters.getParameterSpec(ECParameterSpec.class);
            ECPoint pubPoint = new ECPoint(this.ecdsaPublicKey.getX(), this.ecdsaPublicKey.getY());
            ECPublicKeySpec publicKeySpec = new ECPublicKeySpec(pubPoint, ecParameters);
            KeyFactory keyFactory = KeyFactory.getInstance("EC", SecurityProviderUtility.getBCProvider());
            PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
            Signature sig = Signature.getInstance(algorithm, SecurityProviderUtility.getBCProvider());
            sig.initVerify(publicKey);
            sig.update(sigInBytes);
            return sig.verify(sigBytes);
        }
        catch (InvalidKeySpecException e) {
            throw new SignatureException(e);
        }
        catch (InvalidKeyException e) {
            throw new SignatureException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SignatureException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new SignatureException(e);
        }
        catch (Exception e) {
            throw new SignatureException(e);
        }
    }
}

