/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.jws;

import java.security.SignatureException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.oxauth.model.exception.InvalidJwtException;
import org.gluu.oxauth.model.jws.JwsSigner;
import org.gluu.oxauth.model.jwt.Jwt;
import org.gluu.oxauth.model.util.HashUtil;

public abstract class AbstractJwsSigner
implements JwsSigner {
    private static final Logger LOG = Logger.getLogger(AbstractJwsSigner.class);
    private SignatureAlgorithm signatureAlgorithm;

    public AbstractJwsSigner(SignatureAlgorithm signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    @Override
    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    @Override
    public Jwt sign(Jwt jwt) throws InvalidJwtException, SignatureException {
        String signature = this.generateSignature(jwt.getSigningInput());
        jwt.setEncodedSignature(signature);
        return jwt;
    }

    @Override
    public boolean validate(Jwt jwt) {
        try {
            String signingInput = jwt.getSigningInput();
            String signature = jwt.getEncodedSignature();
            return this.validateSignature(signingInput, signature);
        }
        catch (InvalidJwtException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        catch (SignatureException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean validateAuthorizationCode(String authorizationCode, Jwt idToken) {
        return this.validateHash(authorizationCode, idToken.getClaims().getClaimAsString("c_hash"));
    }

    public boolean validateAccessToken(String accessToken, Jwt idToken) {
        return this.validateHash(accessToken, idToken.getClaims().getClaimAsString("at_hash"));
    }

    public boolean validateState(String state, Jwt idToken) {
        return this.validateHash(state, idToken.getClaims().getClaimAsString("s_hash"));
    }

    private boolean validateHash(String tokenCode, String tokenHash) {
        if (StringUtils.isBlank((String)tokenCode) || StringUtils.isBlank((String)tokenHash)) {
            return false;
        }
        return tokenHash.equals(HashUtil.getHash(tokenCode, this.signatureAlgorithm));
    }

    public abstract String generateSignature(String var1) throws SignatureException;

    public abstract boolean validateSignature(String var1, String var2) throws SignatureException;
}

