/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.jwk;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.List;
import org.gluu.oxauth.model.jwk.JSONWebKey;
import org.gluu.persist.annotation.AttributeEnum;

public enum KeySelectionStrategy implements AttributeEnum
{
    OLDER,
    NEWER,
    FIRST;


    public String getValue() {
        return this.name();
    }

    public Enum<? extends AttributeEnum> resolveByValue(String s) {
        try {
            return KeySelectionStrategy.valueOf(s);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @JsonIgnore
    public JSONWebKey select(List<JSONWebKey> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        if (this == FIRST) {
            return list.iterator().next();
        }
        if (this == OLDER) {
            return Collections.min(list);
        }
        if (this == NEWER) {
            return Collections.max(list);
        }
        return null;
    }
}

