/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.jwk;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsonorg.JsonOrgModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.gluu.oxauth.model.crypto.signature.AlgorithmFamily;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.oxauth.model.jwk.JSONWebKey;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONWebKeySet {
    private static final Logger LOG = Logger.getLogger(JSONWebKeySet.class);
    private List<JSONWebKey> keys = new ArrayList<JSONWebKey>();

    public List<JSONWebKey> getKeys() {
        return this.keys;
    }

    public void setKeys(List<JSONWebKey> keys) {
        this.keys = keys;
    }

    public JSONWebKey getKey(String keyId) {
        for (JSONWebKey jsonWebKey : this.keys) {
            if (!jsonWebKey.getKid().equals(keyId)) continue;
            return jsonWebKey;
        }
        return null;
    }

    @Deprecated
    public List<JSONWebKey> getKeys(SignatureAlgorithm algorithm) {
        ArrayList<JSONWebKey> jsonWebKeys = new ArrayList<JSONWebKey>();
        if (AlgorithmFamily.RSA.equals((Object)algorithm.getFamily())) {
            for (JSONWebKey jsonWebKey : this.keys) {
                if (!jsonWebKey.getAlg().equals(algorithm.getName())) continue;
                jsonWebKeys.add(jsonWebKey);
            }
        } else if (AlgorithmFamily.EC.equals((Object)algorithm.getFamily())) {
            for (JSONWebKey jsonWebKey : this.keys) {
                if (!jsonWebKey.getAlg().equals(algorithm.getName())) continue;
                jsonWebKeys.add(jsonWebKey);
            }
        }
        Collections.sort(jsonWebKeys);
        return jsonWebKeys;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jsonObj = new JSONObject();
        JSONArray keys = new JSONArray();
        for (JSONWebKey key : this.getKeys()) {
            JSONObject jsonKeyValue = key.toJSONObject();
            keys.put((Object)jsonKeyValue);
        }
        jsonObj.put("keys", (Object)keys);
        return jsonObj;
    }

    public String toString() {
        try {
            JSONObject jwks = this.toJSONObject();
            return this.toPrettyJson(jwks).replace("\\/", "/");
        }
        catch (JSONException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        catch (JsonProcessingException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private String toPrettyJson(JSONObject jsonObject) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JsonOrgModule());
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonObject);
    }

    public static JSONWebKeySet fromJSONObject(JSONObject jwksJSONObject) throws JSONException {
        JSONWebKeySet jwks = new JSONWebKeySet();
        JSONArray jwksJsonArray = jwksJSONObject.getJSONArray("keys");
        for (int i = 0; i < jwksJsonArray.length(); ++i) {
            JSONObject jwkJsonObject = jwksJsonArray.getJSONObject(i);
            JSONWebKey jwk = JSONWebKey.fromJSONObject(jwkJsonObject);
            jwks.getKeys().add(jwk);
        }
        return jwks;
    }
}

