/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.jwk;

import java.util.List;
import org.gluu.oxauth.model.crypto.signature.ECEllipticCurve;
import org.gluu.oxauth.model.jwk.Algorithm;
import org.gluu.oxauth.model.jwk.KeyType;
import org.gluu.oxauth.model.jwk.Use;
import org.gluu.oxauth.model.util.StringUtils;
import org.gluu.oxauth.model.util.Util;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONWebKey
implements Comparable<JSONWebKey> {
    private String kid;
    private KeyType kty;
    private Use use;
    private Algorithm alg;
    private Long exp;
    private ECEllipticCurve crv;
    private List<String> x5c;
    private String n;
    private String e;
    private String x;
    private String y;

    public String getKid() {
        return this.kid;
    }

    public void setKid(String kid) {
        this.kid = kid;
    }

    public KeyType getKty() {
        return this.kty;
    }

    public void setKty(KeyType kty) {
        this.kty = kty;
    }

    public Use getUse() {
        return this.use;
    }

    public void setUse(Use use) {
        this.use = use;
    }

    public Algorithm getAlg() {
        return this.alg;
    }

    public void setAlg(Algorithm alg) {
        this.alg = alg;
    }

    public Long getExp() {
        return this.exp;
    }

    public void setExp(Long exp) {
        this.exp = exp;
    }

    public ECEllipticCurve getCrv() {
        return this.crv;
    }

    public void setCrv(ECEllipticCurve crv) {
        this.crv = crv;
    }

    public List<String> getX5c() {
        return this.x5c;
    }

    public void setX5c(List<String> x5c) {
        this.x5c = x5c;
    }

    public String getN() {
        return this.n;
    }

    public void setN(String n) {
        this.n = n;
    }

    public String getE() {
        return this.e;
    }

    public void setE(String e) {
        this.e = e;
    }

    public String getX() {
        return this.x;
    }

    public void setX(String x) {
        this.x = x;
    }

    public String getY() {
        return this.y;
    }

    public void setY(String y) {
        this.y = y;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("kid", (Object)this.kid);
        jsonObj.put("kty", (Object)this.kty);
        jsonObj.put("use", (Object)(this.use != null ? this.use.getParamName() : ""));
        jsonObj.put("alg", (Object)this.alg);
        jsonObj.put("exp", (Object)this.exp);
        jsonObj.put("crv", (Object)(this.crv != null ? this.crv.getName() : ""));
        if (!Util.isNullOrEmpty(this.n)) {
            jsonObj.put("n", (Object)this.n);
        }
        if (!Util.isNullOrEmpty(this.e)) {
            jsonObj.put("e", (Object)this.e);
        }
        if (!Util.isNullOrEmpty(this.x)) {
            jsonObj.put("x", (Object)this.x);
        }
        if (!Util.isNullOrEmpty(this.y)) {
            jsonObj.put("y", (Object)this.y);
        }
        if (this.x5c != null && !this.x5c.isEmpty()) {
            jsonObj.put("x5c", (Object)StringUtils.toJSONArray(this.x5c));
        }
        return jsonObj;
    }

    @Override
    public int compareTo(JSONWebKey o) {
        if (this.getExp() == null || o.getExp() == null) {
            return 0;
        }
        return this.getExp().compareTo(o.getExp());
    }

    public static JSONWebKey fromJSONObject(JSONObject jwkJSONObject) throws JSONException {
        JSONWebKey jwk = new JSONWebKey();
        jwk.setKid(jwkJSONObject.optString("kid"));
        jwk.setKty(KeyType.fromString(jwkJSONObject.optString("kty")));
        jwk.setUse(Use.fromString(jwkJSONObject.optString("use")));
        jwk.setAlg(Algorithm.fromString(jwkJSONObject.optString("alg")));
        if (jwkJSONObject.has("exp")) {
            jwk.setExp(jwkJSONObject.optLong("exp"));
        }
        jwk.setCrv(ECEllipticCurve.fromString(jwkJSONObject.optString("crv")));
        if (jwkJSONObject.has("n")) {
            jwk.setN(jwkJSONObject.optString("n"));
        }
        if (jwkJSONObject.has("e")) {
            jwk.setE(jwkJSONObject.optString("e"));
        }
        if (jwkJSONObject.has("x")) {
            jwk.setX(jwkJSONObject.optString("x"));
        }
        if (jwkJSONObject.has("y")) {
            jwk.setY(jwkJSONObject.optString("y"));
        }
        if (jwkJSONObject.has("x5c")) {
            jwk.setX5c(StringUtils.toList(jwkJSONObject.optJSONArray("x5c")));
        }
        return jwk;
    }
}

