/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.jwk;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import org.gluu.oxauth.model.crypto.signature.AlgorithmFamily;
import org.gluu.oxauth.model.jwk.Use;
import org.gluu.oxauth.model.util.StringUtils;

public enum Algorithm {
    RS256("RS256", Use.SIGNATURE, AlgorithmFamily.RSA, 2048),
    RS384("RS384", Use.SIGNATURE, AlgorithmFamily.RSA, 2048),
    RS512("RS512", Use.SIGNATURE, AlgorithmFamily.RSA, 2048),
    ES256("ES256", Use.SIGNATURE, AlgorithmFamily.EC, 256),
    ES384("ES384", Use.SIGNATURE, AlgorithmFamily.EC, 384),
    ES512("ES512", Use.SIGNATURE, AlgorithmFamily.EC, 528),
    PS256("PS256", Use.SIGNATURE, AlgorithmFamily.RSA, 2048),
    PS384("PS384", Use.SIGNATURE, AlgorithmFamily.RSA, 2048),
    PS512("PS512", Use.SIGNATURE, AlgorithmFamily.RSA, 2048),
    RSA1_5("RSA1_5", Use.ENCRYPTION, AlgorithmFamily.RSA, 2048),
    RSA_OAEP("RSA-OAEP", Use.ENCRYPTION, AlgorithmFamily.RSA, 2048);

    private final String paramName;
    private final Use use;
    private final AlgorithmFamily family;
    private final int keyLength;

    private Algorithm(String paramName, Use use, AlgorithmFamily family, int keyLength) {
        this.paramName = paramName;
        this.use = use;
        this.family = family;
        this.keyLength = keyLength;
    }

    public String getParamName() {
        return this.paramName;
    }

    public Use getUse() {
        return this.use;
    }

    public AlgorithmFamily getFamily() {
        return this.family;
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    @JsonCreator
    public static Algorithm fromString(String param) {
        if (param != null) {
            for (Algorithm algorithm : Algorithm.values()) {
                if (!param.equals(algorithm.paramName)) continue;
                return algorithm;
            }
        }
        return null;
    }

    public static List<Algorithm> fromString(String[] params, Use use) {
        ArrayList<Algorithm> algorithms = new ArrayList<Algorithm>();
        for (String param : params) {
            Algorithm algorithm = Algorithm.fromString(param);
            if (algorithm != null && algorithm.use == use) {
                algorithms.add(algorithm);
                continue;
            }
            if (!StringUtils.equals("RSA_OAEP", param)) continue;
            algorithms.add(RSA_OAEP);
        }
        return algorithms;
    }

    @JsonValue
    public String toString() {
        return this.paramName;
    }
}

