/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.jwe;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.gluu.oxauth.model.crypto.encryption.BlockEncryptionAlgorithm;
import org.gluu.oxauth.model.exception.InvalidParameterException;
import org.gluu.oxauth.model.util.Base64Util;
import org.gluu.util.security.SecurityProviderUtility;

public class KeyDerivationFunction {
    public static byte[] generateCek(byte[] cmk, BlockEncryptionAlgorithm blockEncryptionAlgorithm) throws UnsupportedEncodingException, NoSuchProviderException, NoSuchAlgorithmException, InvalidParameterException {
        if (cmk == null) {
            throw new InvalidParameterException("The content master key (CMK) is null");
        }
        if (blockEncryptionAlgorithm == null) {
            throw new InvalidParameterException("The block encryption algorithm is null");
        }
        if (blockEncryptionAlgorithm != BlockEncryptionAlgorithm.A128CBC_PLUS_HS256 && blockEncryptionAlgorithm != BlockEncryptionAlgorithm.A256CBC_PLUS_HS512) {
            throw new InvalidParameterException("The block encryption algorithm is not supported");
        }
        byte[] round1 = Base64Util.unsignedToBytes(new int[]{0, 0, 0, 1});
        byte[] outputBitSize = null;
        outputBitSize = blockEncryptionAlgorithm != BlockEncryptionAlgorithm.A128CBC_PLUS_HS256 ? Base64Util.unsignedToBytes(new int[]{0, 0, 0, 128}) : Base64Util.unsignedToBytes(new int[]{0, 0, 1, 0});
        byte[] encValue = blockEncryptionAlgorithm.getName().getBytes("UTF-8");
        byte[] epu = Base64Util.unsignedToBytes(new int[]{0, 0, 0, 0});
        byte[] epv = Base64Util.unsignedToBytes(new int[]{0, 0, 0, 0});
        byte[] label = "Encryption".getBytes("UTF-8");
        byte[] round1Input = ArrayUtils.addAll((byte[])round1, (byte[])cmk);
        round1Input = ArrayUtils.addAll((byte[])round1Input, (byte[])outputBitSize);
        round1Input = ArrayUtils.addAll((byte[])round1Input, (byte[])encValue);
        round1Input = ArrayUtils.addAll((byte[])round1Input, (byte[])epu);
        round1Input = ArrayUtils.addAll((byte[])round1Input, (byte[])epv);
        round1Input = ArrayUtils.addAll((byte[])round1Input, (byte[])label);
        MessageDigest mda = MessageDigest.getInstance(blockEncryptionAlgorithm.getMessageDiggestAlgorithm(), SecurityProviderUtility.getBCProvider());
        byte[] round1Hash = mda.digest(round1Input);
        byte[] cek = Arrays.copyOf(round1Hash, blockEncryptionAlgorithm.getCekLength() / 8);
        return cek;
    }

    public static byte[] generateCik(byte[] cmk, BlockEncryptionAlgorithm blockEncryptionAlgorithm) throws UnsupportedEncodingException, NoSuchProviderException, NoSuchAlgorithmException, InvalidParameterException {
        if (cmk == null) {
            throw new InvalidParameterException("The content master key (CMK) is null");
        }
        if (blockEncryptionAlgorithm == null) {
            throw new InvalidParameterException("The block encryption algorithm is null");
        }
        if (blockEncryptionAlgorithm != BlockEncryptionAlgorithm.A128CBC_PLUS_HS256 && blockEncryptionAlgorithm != BlockEncryptionAlgorithm.A256CBC_PLUS_HS512) {
            throw new InvalidParameterException("The block encryption algorithm is not supported");
        }
        byte[] round1 = Base64Util.unsignedToBytes(new int[]{0, 0, 0, 1});
        byte[] outputBitSize = null;
        outputBitSize = blockEncryptionAlgorithm != BlockEncryptionAlgorithm.A128CBC_PLUS_HS256 ? Base64Util.unsignedToBytes(new int[]{0, 0, 1, 0}) : Base64Util.unsignedToBytes(new int[]{0, 0, 2, 0});
        byte[] encValue = blockEncryptionAlgorithm.getName().getBytes("UTF-8");
        byte[] epu = Base64Util.unsignedToBytes(new int[]{0, 0, 0, 0});
        byte[] epv = Base64Util.unsignedToBytes(new int[]{0, 0, 0, 0});
        byte[] label = "Integrity".getBytes("UTF-8");
        byte[] round1Input = ArrayUtils.addAll((byte[])round1, (byte[])cmk);
        round1Input = ArrayUtils.addAll((byte[])round1Input, (byte[])outputBitSize);
        round1Input = ArrayUtils.addAll((byte[])round1Input, (byte[])encValue);
        round1Input = ArrayUtils.addAll((byte[])round1Input, (byte[])epu);
        round1Input = ArrayUtils.addAll((byte[])round1Input, (byte[])epv);
        round1Input = ArrayUtils.addAll((byte[])round1Input, (byte[])label);
        MessageDigest mda = MessageDigest.getInstance(blockEncryptionAlgorithm.getMessageDiggestAlgorithm(), SecurityProviderUtility.getBCProvider());
        byte[] cik = mda.digest(round1Input);
        return cik;
    }
}

