/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.jwe;

import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.crypto.factories.DefaultJWEDecrypterFactory;
import com.nimbusds.jose.jca.JWEJCAContext;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.SignedJWT;
import java.security.Key;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.util.Arrays;
import javax.crypto.spec.SecretKeySpec;
import org.gluu.oxauth.model.crypto.encryption.BlockEncryptionAlgorithm;
import org.gluu.oxauth.model.crypto.encryption.KeyEncryptionAlgorithm;
import org.gluu.oxauth.model.crypto.signature.RSAPrivateKey;
import org.gluu.oxauth.model.exception.InvalidJweException;
import org.gluu.oxauth.model.exception.InvalidJwtException;
import org.gluu.oxauth.model.jwe.AbstractJweDecrypter;
import org.gluu.oxauth.model.jwe.Jwe;
import org.gluu.oxauth.model.jwt.Jwt;
import org.gluu.oxauth.model.jwt.JwtClaims;
import org.gluu.oxauth.model.jwt.JwtHeader;
import org.gluu.util.security.SecurityProviderUtility;

public class JweDecrypterImpl
extends AbstractJweDecrypter {
    private static final DefaultJWEDecrypterFactory DECRYPTER_FACTORY = new DefaultJWEDecrypterFactory();
    private PrivateKey privateKey;
    private RSAPrivateKey rsaPrivateKey;
    private byte[] sharedSymmetricKey;

    public JweDecrypterImpl(byte[] sharedSymmetricKey) {
        if (sharedSymmetricKey != null) {
            this.sharedSymmetricKey = (byte[])sharedSymmetricKey.clone();
        }
    }

    public JweDecrypterImpl(RSAPrivateKey rsaPrivateKey) {
        this.rsaPrivateKey = rsaPrivateKey;
    }

    public JweDecrypterImpl(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    @Override
    public Jwe decrypt(String encryptedJwe) throws InvalidJweException {
        try {
            String[] jweParts = encryptedJwe.split("\\.");
            if (jweParts.length != 5) {
                throw new InvalidJwtException("Invalid JWS format.");
            }
            String encodedHeader = jweParts[0];
            String encodedEncryptedKey = jweParts[1];
            String encodedInitializationVector = jweParts[2];
            String encodedCipherText = jweParts[3];
            String encodedIntegrityValue = jweParts[4];
            Jwe jwe = new Jwe();
            jwe.setEncodedHeader(encodedHeader);
            jwe.setEncodedEncryptedKey(encodedEncryptedKey);
            jwe.setEncodedInitializationVector(encodedInitializationVector);
            jwe.setEncodedCiphertext(encodedCipherText);
            jwe.setEncodedIntegrityValue(encodedIntegrityValue);
            jwe.setHeader(new JwtHeader(encodedHeader));
            EncryptedJWT encryptedJwt = EncryptedJWT.parse((String)encryptedJwe);
            this.setKeyEncryptionAlgorithm(KeyEncryptionAlgorithm.fromName(jwe.getHeader().getClaimAsString("alg")));
            this.setBlockEncryptionAlgorithm(BlockEncryptionAlgorithm.fromName(jwe.getHeader().getClaimAsString("enc")));
            KeyEncryptionAlgorithm keyEncryptionAlgorithm = this.getKeyEncryptionAlgorithm();
            Key encriptionKey = null;
            if (keyEncryptionAlgorithm == KeyEncryptionAlgorithm.RSA1_5 || keyEncryptionAlgorithm == KeyEncryptionAlgorithm.RSA_OAEP) {
                encriptionKey = this.privateKey;
            } else if (keyEncryptionAlgorithm == KeyEncryptionAlgorithm.A128KW || keyEncryptionAlgorithm == KeyEncryptionAlgorithm.A256KW) {
                if (this.sharedSymmetricKey == null) {
                    throw new InvalidJweException("The shared symmetric key is null");
                }
                int keyLength = 16;
                if (keyEncryptionAlgorithm == KeyEncryptionAlgorithm.A256KW) {
                    keyLength = 32;
                }
                if (this.sharedSymmetricKey.length != keyLength) {
                    MessageDigest sha = MessageDigest.getInstance("SHA-256");
                    this.sharedSymmetricKey = sha.digest(this.sharedSymmetricKey);
                    this.sharedSymmetricKey = Arrays.copyOf(this.sharedSymmetricKey, keyLength);
                }
                encriptionKey = new SecretKeySpec(this.sharedSymmetricKey, 0, this.sharedSymmetricKey.length, "AES");
            } else {
                throw new InvalidJweException("The key encryption algorithm is not supported");
            }
            JWEDecrypter decrypter = DECRYPTER_FACTORY.createJWEDecrypter(encryptedJwt.getHeader(), encriptionKey);
            ((JWEJCAContext)decrypter.getJCAContext()).setProvider(SecurityProviderUtility.getBCProvider());
            encryptedJwt.decrypt(decrypter);
            SignedJWT signedJWT = encryptedJwt.getPayload().toSignedJWT();
            if (signedJWT != null) {
                Jwt jwt = Jwt.parse(signedJWT.serialize());
                jwe.setSignedJWTPayload(jwt);
                jwe.setClaims(jwt != null ? jwt.getClaims() : null);
            } else {
                String base64encodedPayload = encryptedJwt.getPayload().toString();
                jwe.setClaims(new JwtClaims(base64encodedPayload));
            }
            return jwe;
        }
        catch (Exception e) {
            throw new InvalidJweException(e);
        }
    }
}

