/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.fido.u2f.protocol;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import org.gluu.oxauth.model.fido.u2f.exception.BadInputException;
import org.gluu.oxauth.model.util.Base64Util;

public class ClientData
implements Serializable {
    private static final long serialVersionUID = -1483378146391551962L;
    private static final String TYPE_PARAM = "typ";
    private static final String CHALLENGE_PARAM = "challenge";
    private static final String ORIGIN_PARAM = "origin";
    private final String typ;
    private final String challenge;
    private final String origin;
    private final String rawClientData;
    private final JsonNode data;

    public ClientData(String clientData) throws BadInputException {
        this.rawClientData = new String(Base64Util.base64urldecode(clientData));
        try {
            this.data = new ObjectMapper().readTree(this.rawClientData);
            this.typ = this.getString(TYPE_PARAM);
            this.challenge = this.getString(CHALLENGE_PARAM);
            this.origin = this.getString(ORIGIN_PARAM);
        }
        catch (IOException ex) {
            throw new BadInputException("Malformed ClientData", ex);
        }
    }

    public String getTyp() {
        return this.typ;
    }

    public String getChallenge() {
        return this.challenge;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getString(String key) {
        return this.data.get(key).asText();
    }

    public String getRawClientData() {
        return this.rawClientData;
    }

    public String toString() {
        return this.rawClientData;
    }
}

